#ifndef	COLLECTION_H
#define	COLLECTION_H
                  
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */                  
/* Collection.h,v 3.16 92/12/19 15:38:27 */

#include "nihclstd.h"
#pragma hdrstop

class Collection;
#include "Iterator.h"

class ArrayOb;
class Bag;
class Heap;
class Iterator;
class OrderedCltn;
class Set;
class SortedCltn;

class Collection: public VIRTUAL Object {	// abstract class 
	DECLARE_MEMBERS(Collection);
public:
	static const unsigned DEFAULT_CAPACITY;		// default initial collection capacity 
	static const unsigned EXPANSION_INCREMENT;	// collection (OrderedCltn) expansion increment 
	static const unsigned EXPANSION_FACTOR;		// collection (Set,Bag,Dictionary) expansion factor 
protected:
	Collection();
protected:		// _storer()/_reader() functions for object I/O
	void _reader(OIOifd&);		// read collection from stream
	void _reader(OIOin&);		// read collection from file
	void _storer(OIOofd&) const;	// store collection using Iterator
	void _storer(OIOout&) const;	// store collection using Iterator
public:
	ArrayOb asArrayOb() const;
	Bag asBag() const;
	Heap asHeap() const;
	OrderedCltn asOrderedCltn() const;
	Set asSet() const;
	SortedCltn asSortedCltn() const;
	virtual ~Collection();		// Collection destructors are virtual
	virtual	Object* add(Object&) = 0;
	virtual const Collection& addAll(const Collection&);
	virtual Collection& addContentsTo(Collection&) const;
	virtual Object*& at(int) = 0;
	virtual const Object *const& at(int) const = 0;
	virtual bool sameContentsAs(const Collection& c) const;
	virtual	void deepenShallowCopy();   // {}
	virtual	void doFinish(Iterator& pos) const;
	virtual	Object* doNext(Iterator&) const = 0;
	virtual	void doReset(Iterator& pos) const;
	virtual void dumpOn(ostream& strm =cerr) const;
#if !defined(LINKPUREVIRT)	         
	virtual unsigned capacity() const = 0;	
	virtual int compare(const Object&) const = 0;
	virtual unsigned long hash() const = 0;
	virtual bool isEqual(const Object&) const = 0; 
	virtual unsigned size() const = 0;
#else                            
	virtual unsigned capacity() const;                                      
	virtual int compare(const Object&) const;         
   virtual unsigned long hash() const;  
   virtual bool isEqual(const Object&) const;
   virtual unsigned size() const;
#endif	
	virtual bool includes(const Object&) const;
	virtual bool isEmpty() const;
	virtual unsigned occurrencesOf(const Object&) const = 0;
	virtual void printOn(ostream& strm =cout) const;
	virtual Object* remove(const Object&) = 0;
	virtual void removeAll() = 0;
	virtual const Collection& removeCltn(const Collection&);
	virtual void reSize(unsigned) = 0;

};



#endif
