#ifndef	DICTIONARY_H
#define	DICTIONARY_H
      
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */      
/* Dictionary.h,v 3.11 92/07/26 14:32:11 */

#include "nihclstd.h"
#pragma hdrstop

#include "Set.h"

class Assoc;
class LookupKey;
class OrderedCltn;

class Dictionary: public Set {
	DECLARE_MEMBERS(Dictionary);
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Set::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ Set::storer(strm); };
public:
	Dictionary(unsigned size =DEFAULT_CAPACITY);
	bool operator==(const Dictionary&) const;
	bool operator!=(const Dictionary& d) const { return !(*this == d); }
	virtual	Object* add(Object&);
	virtual Assoc* addAssoc(Object& key, Object& value);
	virtual Collection& addContentsTo(Collection&) const;
	virtual Collection& addKeysTo(Collection&) const;
	virtual Collection& addValuesTo(Collection&) const;
	virtual LookupKey* assocAt(const Object& key) const;
	virtual Object* atKey(const Object& key) const;
	virtual Object* atKey(const Object& key, Object& newValue);
	virtual bool includesAssoc(const LookupKey& asc) const;
	virtual bool includesKey(const Object& key) const;
	virtual bool isEqual(const Object&) const;
	virtual Object* keyAtValue(const Object& val) const;
	virtual unsigned occurrencesOf(const Object& val) const;
	virtual Object* remove(const Object& asc);
	virtual LookupKey* removeAssoc(const LookupKey& asc);
	virtual LookupKey* removeKey(const Object& key);
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
