#ifndef	FRACTION_H
#define	FRACTION_H
                  
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */                  
/* Fraction.h,v 3.11 92/07/26 14:32:21 */

#include "nihclstd.h"
#pragma hdrstop


class Fraction: public VIRTUAL Object {
	DECLARE_MEMBERS(Fraction);
public:			// static member functions
	static int gcd(int uu, int vv);
private:
	int n,d;
	Fraction(int num, int den, int dum) {
		n = (dum,num); d = den;
	}
	void parseFraction(istream&);
	void reduce();
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Fraction(int num =0, int den =1);
	Fraction(double);
#if defined(MIBADDEFAULTFCNS)
	Fraction(const Fraction& copyfrom);
	Fraction& operator=(const Fraction& rhs);
#endif
	Fraction(istream&);
	operator double() const		{ return (double)n/d; }
	int denominator() const		{ return d; }
	int numerator() const		{ return n; }
	
	friend Fraction	operator+(const Fraction&, const Fraction&);
	friend Fraction	operator-(const Fraction& u)  { return Fraction(-u.n,u.d); }
	friend Fraction operator-(const Fraction&, const Fraction&);
	friend Fraction operator*(const Fraction&, const Fraction&);
	friend Fraction operator/(const Fraction&, const Fraction&);
	friend bool	operator<(const Fraction& u, const Fraction& v);
	friend bool	operator>(const Fraction& u, const Fraction& v)		{ return v<u; }
	friend bool	operator<=(const Fraction& u, const Fraction& v);
	friend bool	operator>=(const Fraction& u, const Fraction& v)	{ return v<=u; }
	friend bool	operator==(const Fraction& u, const Fraction& v) 	{ return u.n == v.n && u.d == v.d; }
	friend bool	operator!=(const Fraction& u, const Fraction& v)	{ return !(u==v); }
	
	void operator+=(const Fraction& u)	{ *this = *this + u; }
	void operator-=(const Fraction& u)	{ *this = *this - u; }
	void operator*=(const Fraction& u)	{ *this = *this * u; }
	void operator/=(const Fraction& u)	{ *this = *this / u; }
	
	bool between(const Fraction& min, const Fraction& max) const;
	Fraction max(const Fraction&) const;
	Fraction min(const Fraction&) const;
	
	virtual int compare(const Object&) const;
	virtual void	deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
