#ifndef	HEAP_H
#define	HEAP_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Heap.h,v 3.13 92/07/26 14:32:24 */

#include "nihclstd.h"
#pragma hdrstop

#include "Collecti.h"
#include "OrderedC.h"
#include "ArrayOb.h"

class Heap: public SeqCltn {
	DECLARE_MEMBERS(Heap);
	int endIndex;   	
	ArrayOb contents;
private:		// static member functions 
	// unsigned MFM
	static int child(int i)		{ return (i << 1) + 1; }
	static int grandchild(int i)	{ return (child(i) << 1) + 1; }
	static int parent(int i)	{ return (i - 1) >> 1; }
	static int level(int);
private:
	void bubbleUp(int);
	void bubbleUpMax(int);
	void bubbleUpMin(int);
	int descendents(int) const;
	void errEmpty(const char* fn) const;
	int largest(int,int) const;
	Object* removeAtIndex(int i);
	int smallest(int,int) const;
	void swap(int a,int b) 	{
		Object* temp = contents[a];
		contents[a] = contents[b]; 
		contents[b] = temp;
	}
	void trickleDown(int);
	void trickleDownMax(int);
	void trickleDownMin(int);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Heap(int size=DEFAULT_CAPACITY);
	Heap(const ArrayOb&);
	Heap(const Heap&);
	bool operator==(const Heap&) const;
	bool operator!=(const Heap& a) const {  return !(*this==a);  }
	virtual Object* add(Object&);
	virtual Object*& at(int index);
	virtual const Object *const& at(int index) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual	void doFinish(Iterator& pos) const;
	virtual Object* doNext(Iterator&) const;
	virtual	void doReset(Iterator& pos) const;
	virtual Object* first() const;
	virtual unsigned long hash() const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeFirst();
	virtual Object* removeId(const Object&);
	virtual Object* removeLast();
	virtual void reSize(unsigned newSize);
	virtual unsigned size() const;
	OrderedCltn sort();
private:					// shouldNotImplement()
	virtual void atAllPut(Object& ob);
	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
