#ifndef	LINK_H
#define	LINK_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Link.h,v 3.11 92/07/26 14:32:36 */

#include "nihclstd.h"
#pragma hdrstop

class LinkedList;

class Link: public VIRTUAL Object {	// abstract class
	DECLARE_MEMBERS(Link);
	Link* next;			// pointer to next Link or nil 
	static Link *const nilLink;	// end of list marker
	friend LinkedList;
protected:
	Link()				{ next = NULL; }
	Link(Link* nextlink)		{ next = nextlink; }
	Link(const Link&)		{ next = NULL; }
public:
	~Link();
	Link* nextLink() const		{ return next; }
	Link* nextLink(Link* nextlink)	{ next = nextlink; return next; }
	bool isListEnd() const		{ return this == nilLink; }

	virtual Object* copy() const;	// deepCopy()
	virtual void deepenShallowCopy();

#if !defined(LINKPUREVIRT)	
	virtual bool isEqual(const Object&) const = 0; 
	virtual int compare(const Object&) const = 0; 
	virtual void printOn(ostream& strm =cout) const = 0;
	virtual unsigned long hash() const = 0;
#else
   virtual bool isEqual(const Object&) const; 
   virtual int compare(const Object&) const;     
   virtual void printOn(ostream& strm =cout) const;
   virtual unsigned long hash() const;
#endif	

};

#endif
