#ifndef	LINKEDLIST_H
#define	LINKEDLIST_H
   
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */   
/* LinkedList.h,v 3.13 92/07/26 14:32:50 */

#include "nihclstd.h"
#pragma hdrstop

#include "SeqCltn.h"
#include "Link.h"

class LinkedList: public SeqCltn {
	DECLARE_MEMBERS(LinkedList);
private:
	Link* firstLink;		// pointer to first Link of list
	Link* lastLink;			// pointer to last Link of list
	unsigned count;			// count of items on list
	void errDblLnk(const char* fn, const Link& lnk) const;
	void errEmpty(const char* fn) const;
	void errNotFound(const char* fn, const Object& ob) const;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
protected:
	virtual Link& linkCastdown(Object&) const;
	Link* linkCastdown(Object* p) const   { return &linkCastdown(*p); }
public:
	LinkedList();
	LinkedList(const LinkedList&);
	bool operator!=(const LinkedList& a) const	{ return !(*this==a); }
	bool operator==(const LinkedList&) const;
	Object* operator[](int i);   
	// make ref - MFM
	const Object *const& operator[](int i) const;
	virtual Object* add(Link&);
	virtual Object* add(Object&);
	virtual Object* addAfter(Link&,Link&);
	virtual Object* addAfter(Object&,Object&);
	virtual Collection& addContentsTo(Collection& cltn) const;
	virtual Object* addFirst(Link&);
	virtual Object* addFirst(Object&);
	virtual Object* addLast(Link&);
	virtual Object* addLast(Object&);
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object* doNext(Iterator&) const;
	virtual Object* first() const;
	virtual unsigned long hash() const;
	virtual bool includes(const Object& ob) const;
 	virtual int indexOf(const Object& ob) const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Link&);
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeFirst();
	virtual Object* removeLast();
	virtual void reSize(unsigned newSize);
	virtual unsigned size() const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual void atAllPut(Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
