#ifndef	NIHREGEX_H
#define	NIHREGEX_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Regex.h,v 3.12 92/07/26 14:33:36 */
          
/*
 * used later version of GNU regex code from diff
*/           
#include "nihclstd.h"
#pragma hdrstop

#include "NIHStrin.h"
#include "Range.h"
#include "regex.h"

class Regex: public String {
	DECLARE_MEMBERS(Regex);
	struct re_pattern_buffer pattern;
	unsigned ngroups;	// 1 + number of \( \) groups in pattern
	struct re_registers regs;
	void re_compile_pattern();
	int re_match(const String&, int pos=0);
	void init(int bufsize);
	void fixCopy();
	void setGroups(int);
	void errRegex(const char*) const;
public:
	static const unsigned DEFAULT_BUFSIZE;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Regex(unsigned bufsize =DEFAULT_BUFSIZE);
	Regex(const char*, unsigned bufsize =DEFAULT_BUFSIZE);
	Regex(const Regex&);
   Regex(const String&, unsigned bufsize =DEFAULT_BUFSIZE );
   Regex(const SubString&, unsigned bufsize =DEFAULT_BUFSIZE);
	~Regex();
	Range operator[](unsigned) const;
	unsigned groups() const	{ return ngroups; }
	bool match(const String&, int pos=0);
	int search(const String&, int startpos=0);
	int search(const String&, int startpos, int range);
	void operator=(const char*);
	void operator=(const String&);
	void operator=(const SubString&);
	void operator=(const Regex&);
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual void scanFrom(istream& strm);
	virtual void toAscii();
	virtual void toLower();
	virtual void toUpper();
private:
	String& operator&=(const String&)	{ shouldNotImplement("operator&="); return *this; }
	String& operator&=(const SubString&)	{ shouldNotImplement("operator&="); return *this; }
	String& operator&=(const char*)		{ shouldNotImplement("operator&="); return *this; }
};


#endif  /* NIHREGEX_H */
