#ifndef	TIME_H
#define	TIME_H
               
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */               
/* Time.h,v 3.11 92/07/26 14:33:59 */

#include "nihclstd.h"
#pragma hdrstop

class Date;

class Time: public VIRTUAL Object {
	DECLARE_MEMBERS(Time);
public:			// type definitions
	typedef unsigned short hourTy;
	typedef unsigned short minuteTy;
	typedef unsigned short secondTy;
	typedef unsigned long clockTy;
private:
	clockTy sec;			/* seconds since 1/1/1901 */
	bool isDST() const;
	Time localTime() const;
private:		// static member functions
	static Time localTime(const Date& date, hourTy h=0, minuteTy m=0, secondTy s=0);
	static Time beginDST(unsigned year);
	static Time endDST(unsigned year);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Time();				// current time 
	Time(clockTy s)			{ sec = s; }
	Time(hourTy h, minuteTy m, secondTy s =0, bool dst =NO);
	Time(const Date&, hourTy h =0, minuteTy m =0, secondTy s=0, bool dst =NO);
#if defined(MIBADDEFAULTFCNS)
	Time(const Time& copyfrom);     
	Time& operator=(const Time& rhs);
#endif
	operator Date() const;
	bool operator<(const Time& t) const	{ return sec < t.sec; }
	bool operator<=(const Time& t) const	{ return sec <= t.sec; }
	bool operator>(const Time& t) const	{ return sec > t.sec; }
	bool operator>=(const Time& t) const	{ return sec >= t.sec; }
	bool operator==(const Time& t) const	{ return sec == t.sec; }
	bool operator!=(const Time& t) const	{ return sec != t.sec; }
	friend Time operator+(const Time& t, long s)	{ return Time(t.sec+s); }
	friend Time operator+(long s, const Time& t)	{ return Time(t.sec+s); }
	long operator-(const Time& t) const	{ return sec - t.sec; }
	Time operator-(long s) const	{ return Time(sec-s); }
	void operator+=(long s)		{ sec += s; }
	void operator-=(long s)		{ sec -= s; }
	bool between(const Time& a, const Time& b) const;
	hourTy hour() const;				// hour in local time 
	hourTy hourGMT() const;			// hour in GMT 
	minuteTy minute() const;		// minute in local time 
	minuteTy minuteGMT() const;	// minute in GMT 
	secondTy second() const;		// second in local time or GMT 
	clockTy	seconds() const		{ return sec; }
	Time max(const Time&) const;
	Time min(const Time&) const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
};

#endif /* TIMEH */
