#ifndef	OIOSTREAM_H
#define	OIOSTREAM_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* OIOstream.h,v 3.11 92/07/26 14:33:03 */

#include "nihclstd.h"
#pragma hdrstop

#include "OIO.h"

class OIOistream : public OIOin {
protected:
	istream* strm;		// input stream
	void checkRead() const;
	OIOistream& putback(char c) { strm->putback(c); return *this; }
	void syntaxErr(const char* expect, char was) const;
	virtual Object* readObject(const Class&) = 0;
public:
	OIOistream(istream& s, unsigned capacity =1024) : OIOin(capacity)
		{ strm = &s; }
	operator istream&()	{ return *strm; }
	virtual OIOin& operator>>(char*);
	virtual OIOin& operator>>(char&);
	virtual OIOin& operator>>(unsigned char&);
	virtual OIOin& operator>>(short&);
	virtual OIOin& operator>>(unsigned short&);
	virtual OIOin& operator>>(int&);
	virtual OIOin& operator>>(unsigned int&);
	virtual OIOin& operator>>(long&);
	virtual OIOin& operator>>(unsigned long&);
	virtual OIOin& operator>>(float&);
	virtual OIOin& operator>>(double&);
	virtual int get();
	virtual OIOin& get(char&);
	virtual OIOin& get(unsigned char&);
	virtual OIOin& get(char*, unsigned size);
	virtual OIOin& get(unsigned char*, unsigned size);
	virtual OIOin& get(short*,unsigned size);
	virtual OIOin& get(unsigned short*,unsigned size);
	virtual OIOin& get(int*,unsigned size);
	virtual OIOin& get(unsigned int*,unsigned size);
	virtual OIOin& get(long*,unsigned size);
	virtual OIOin& get(unsigned long*,unsigned size);
	virtual OIOin& get(float*,unsigned size);
	virtual OIOin& get(double*,unsigned size);
	virtual OIOin& get(streambuf&, char delim ='\n');
	virtual OIOin& getCString(char*, unsigned maxlen);
	virtual int precision();
	virtual int precision(int);
	virtual int width();
	virtual int width(int);
};

class OIOostream : public OIOout {
protected:
	ostream* strm;			// output stream
	unsigned col;			// current column
	static const unsigned MAXCOL;	// max columns in output line
	void putwrap(char);
	void putwrap(unsigned char c) { putwrap((char)c); }
	void putwrap(const char* s, unsigned len);
	virtual void storeObject(const Object&) = 0;
public:
	OIOostream(ostream& s, unsigned capacity =256) : OIOout(capacity)
		{ strm = &s; col = 0; }
	operator ostream&()	{ return *strm; }
	virtual OIOout& operator<<(const char*);
	virtual OIOout& operator<<(char);
	virtual OIOout& operator<<(unsigned char);
	virtual OIOout& operator<<(short);
	virtual OIOout& operator<<(unsigned short);
	virtual OIOout& operator<<(int);
	virtual OIOout& operator<<(unsigned);
	virtual OIOout& operator<<(long);
	virtual OIOout& operator<<(unsigned long);
	virtual OIOout& operator<<(float);
	virtual OIOout& operator<<(double);
	virtual OIOout& put(char);
	virtual OIOout& put(const char* val, unsigned size);
	virtual OIOout& put(const unsigned char* val, unsigned size);
	virtual OIOout& put(const short* val, unsigned size);
	virtual OIOout& put(const unsigned short* val, unsigned size);
	virtual OIOout& put(const int* val, unsigned size);
	virtual OIOout& put(const unsigned int* val, unsigned size);
	virtual OIOout& put(const long* val, unsigned size);
	virtual OIOout& put(const unsigned long* val, unsigned size);
	virtual OIOout& put(const float* val, unsigned size);
	virtual OIOout& put(const double* val, unsigned size);
	virtual OIOout& putCString(const char*);
	virtual int precision();
	virtual int precision(int);
	virtual int width();
	virtual int width(int);
};

#endif /* OIOSTREAM_H */
