#ifndef OIOTBL_H
#define OIOTBL_H


/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* OIOTbl.h,v 3.12 92/07/26 14:32:57 */

#include "nihclstd.h"
#pragma hdrstop

#include "IdentDic.h"
#include "IdentSet.h"
#include "OrderedC.h"

class StoreOnTblMgr;

class StoreOnTbl : public NIHCL {
	unsigned long level;		// storeOn() nesting level
	IdentDict d;				// object address => object number
	int objNum;					// last object number used
	OrderedCltn c;				// table of classes stored, indexed by class number
	unsigned /*short*/ classNum;// last class number used     /*short*/ MFM
#ifdef MI
	IdentSet storeVBaseTbl;		// table used by virtual base classes during storeOn()
#endif
	friend StoreOnTblMgr;
	void reset();
protected:
	StoreOnTbl(unsigned size =256);
	bool add(const Object&, int& num);
	bool addClass(const Class*, unsigned /*short*/& num);    // /*short*/ MFM
	void addMember(const Object&);
public:
	~StoreOnTbl();
	unsigned long storeOnLevel()	{ return level; }
#ifdef MI
	bool _storeVBase(const void*);
#endif
	OrderedCltn classesStored();
	OrderedCltn objectsStored();
	OrderedCltn membersStored();
	virtual void dumpOn(ostream& strm =cerr) const;
};

class ReadFromTblMgr;

class ReadFromTbl : public NIHCL {
	unsigned long level;		// readFrom() nesting level
	const Class* currentClass;	// current class being read
	unsigned long addObject;	// add object to readFromTbl when 0
	OrderedCltn obs;				// table of objects for readFrom()
	OrderedCltn cls;				// table of classes for readFrom()
	friend ReadFromTblMgr;
	void reset();
protected:
	ReadFromTbl(unsigned size =1024);
	void addObjectEnable()		{ addObject = 0; }
	void add(Object&);
	int add(const Class*);
	const Class* readFromClass(const Class*);
public:
	Object* objectAt(int);
	const Class* classAt(int);
	const Class* readFromClass()	{ return currentClass; }
	unsigned long readFromLevel()	{ return level; }
	OrderedCltn classesRead();
	OrderedCltn objectsRead();
	virtual void dumpOn(ostream& strm =cerr) const;
};

#endif
