#ifndef	ORDEREDCLTN_H
#define	ORDEREDCLTN_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* OrderedCltn.h,v 3.12 92/07/26 14:33:23 */

#include "nihclstd.h"
#pragma hdrstop

#include "SeqCltn.h"
#include "ArrayOb.h" 

class OrderedCltn: public SeqCltn {
	DECLARE_MEMBERS(OrderedCltn);
	void errEmpty(const char* fn) const;
	void errNotFound(const char* fn, const Object& ob) const;
protected:
	int endIndex;     
	ArrayOb contents;
	Object* addAtIndex(int i, Object& ob);
	Object* removeAtIndex(int i);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	OrderedCltn(unsigned size =DEFAULT_CAPACITY);
	OrderedCltn(const OrderedCltn&);
	bool operator!=(const OrderedCltn& a) const { return !(*this==a); }
	bool operator==(const OrderedCltn&) const;
	Object*& operator[](int i) {     	
		if (i >= endIndex || i < 0) 
			indexRangeErr();     
		return contents[i];
	}
	const Object *const& operator[](int i) const {     
		if (i < 0 || i >= endIndex) 
			indexRangeErr();   	
		return contents[i];
	}
	OrderedCltn operator&(const SeqCltn& cltn) const;	// concatenation operator 
	void operator&=(const SeqCltn& cltn);
	virtual Object* add(Object&);
	virtual Object* addAfter(const Object& ob, Object& newob);
	virtual Object* addAllLast(const OrderedCltn&);
	virtual Object* addBefore(const Object& ob, Object& newob);
	virtual Collection& addContentsTo(Collection& cltn) const;
	virtual Object* addLast(Object& ob);
	virtual Object* after(const Object&) const;
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual void atAllPut(Object& ob);
	virtual Object* before(const Object&) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object* first() const;
	virtual unsigned long hash() const;
 	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeId(const Object&);
	virtual Object* removeLast();
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
	virtual void reSize(unsigned newSize);
	virtual unsigned size() const;
	virtual void sort();
};

#endif
