#ifndef	POINT_H
#define	POINT_H
        
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */        
/* Point.h,v 3.11 92/07/26 14:33:25 */ 
/*
 * coords as ints instead of short
 */ 

#include "nihclstd.h"
#pragma hdrstop

#include <math.h>   /* hypot - MFM */

class Point: public VIRTUAL Object {
	DECLARE_MEMBERS(Point);
protected:
	int xc,yc;			// x-y coordinate 
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Point()				{ xc = yc = 0; }
	Point(int newx, int newy)	{ xc=newx; yc=newy; }
#if defined(MIBADDEFAULTFCNS) 
	Point(const Point& copyfrom);
	Point& Point::operator=(const Point& rhs);
#endif
	int x() const			{ return xc; }
	int x(int newx)		{ return xc = newx; }
	int y() const			{ return yc; }
	int y(int newy)		{ return yc = newy; }
	Point operator+(const Point& p) const	{ return Point(xc+p.xc, yc+p.yc); }
	Point operator-() const			{ return Point(-xc,-yc); }
	Point operator-(const Point& p) const	{ return Point(xc-p.xc, yc-p.yc); }
	friend Point operator*(const Point& p, int i) { return Point(i*p.xc, i*p.yc); }
	friend Point operator*(int i, const Point& p) { return Point(i*p.xc, i*p.yc); }
	int operator*(const Point& p) const	{ return xc*p.xc + yc*p.yc; }
	bool operator==(const Point& p) const	{ return (xc==p.xc && yc==p.yc); }
	bool operator!=(const Point& p) const	{ return (xc!=p.xc || yc!=p.yc); }
	bool operator<(const Point& p) const	{ return (yc<p.yc && xc<p.xc); }
	bool operator<=(const Point& p) const	{ return (yc<=p.yc && xc<=p.xc); }
	bool operator>(const Point& p) const	{ return (yc>p.yc && xc>p.xc); }
	bool operator>=(const Point& p) const	{ return (yc>=p.yc && xc>=p.xc); }
	void operator+=(const Point& p)		{ xc += p.xc; yc += p.yc; }
	void operator-=(const Point& p)		{ xc -= p.xc; yc -= p.yc; }
	void operator*=(int s)			{ xc *= s; yc *= s; }
	double dist(const Point& p) const	{ return hypot(xc-p.xc, yc-p.yc); }
	Point max(const Point&) const;
	Point min(const Point&) const;
	Point transpose() const			{ return Point(yc,xc); }
 	bool isBelow(const Point& p) const	{ return yc > p.yc; }
	bool isAbove(const Point& p) const	{ return yc < p.yc; }
	bool isLeft(const Point& p) const	{ return xc < p.xc; }
	bool isRight(const Point& p) const	{ return xc > p.xc; }
	virtual	int compare(const Object&) const;	// compare Points 
	virtual void deepenShallowCopy();	// {}
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;	// equality test 
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
};

#endif
