#ifndef	SEQCLTN_H
#define	SEQCLTN_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* SeqCltn.h,v 3.15 92/12/19 15:41:14 */

#include "nihclstd.h"
#pragma hdrstop

#include "Collecti.h"

class SeqCltn: public Collection {
	DECLARE_MEMBERS(SeqCltn);
protected:
	SeqCltn();
	void indexRangeErr() const;
public:
	virtual	Object* add(Object&) = 0;
	virtual Object*& at(int) = 0;
	virtual const Object *const& at(int) const = 0;
	virtual void atAllPut(Object& ob) = 0;

	virtual int compare(const Object&) const;
	virtual bool sameContentsInOrderAs(const SeqCltn& c) const;
	virtual Object* doNext(Iterator&) const;
	virtual Object* first() const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const = 0;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&) = 0;
	virtual void removeAll() = 0;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0) = 0;
	virtual void reSize(unsigned) = 0;     
#if !defined(LINKPUREVIRT)
	virtual unsigned size() const = 0;
	virtual unsigned capacity() const = 0;
#else
	virtual unsigned size() const;
	virtual unsigned capacity() const;
#endif	
	virtual const Class* species() const;
};

#endif
