#ifndef	SET_H
#define	SET_H

/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */
/* Set.h,v 3.14 92/07/26 14:33:44 */

#include "nihclstd.h"
#pragma hdrstop

#include "Collecti.h"
#include "ArrayOb.h"

class Set: public Collection {
	DECLARE_MEMBERS(Set);
	unsigned count;		// number of objects in set 
	unsigned nbits;		// log base 2 of contents.capacity() 
protected:
	unsigned mask;		// contents.capacity()-1 
	ArrayOb contents;	// array of set objects 
	unsigned setCapacity(unsigned);	// compute set allocation size 
	int h(unsigned long) const;	// convert hash key into contents index 
	virtual	int findIndexOf(const Object&) const;	// search method
	virtual	unsigned long hashOf(const Object&) const;	// hash method
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Set(unsigned size =DEFAULT_CAPACITY);
#if defined(MIBADDEFAULTFCNS)
	Set(const Set& copyfrom);
	Set& operator=(const Set& rhs);
#endif
	bool operator==(const Set&) const;
	bool operator!=(const Set& a) const	{ return !(*this==a); }
	Set operator&(const Set&) const;	// intersection 
	Set operator|(const Set&) const;	// union 
	Set operator-(const Set&) const;	// difference 
	Object* addToSet(Object&);
	virtual Object*	add(Object&);
	virtual Object*& at(int);
	virtual const Object *const& at(int) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object*	doNext(Iterator&) const;
	virtual	Object* findObjectWithKey(const Object&) const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual void reSize(unsigned);
	virtual Object*	remove(const Object&);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
