#ifndef	SORTEDCLTN_H
#define	SORTEDCLTN_H
       
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */       
/* SortedCltn.h,v 3.11 92/07/26 14:33:46 */

#include "nihclstd.h"
#pragma hdrstop

#include "OrderedC.h"
#include "Range.h"

class SortedCltn: public OrderedCltn {
	DECLARE_MEMBERS(SortedCltn);
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ OrderedCltn::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ OrderedCltn::storer(strm); };
public:
	SortedCltn(unsigned size =DEFAULT_CAPACITY);
#if defined(MIBADDEFAULTFCNS)
	SortedCltn(const SortedCltn& copyfrom);
	SortedCltn& operator=(const SortedCltn& rhs);
#endif
	virtual Object* add(Object&);
	int findIndexOf(const Object& key) const;
	virtual unsigned occurrencesOf(const Object&) const;
	Range findRangeOf(const Object& key) const;
	Object* remove(const Object&);
protected:
	int findIndexOfFirstKey(int) const;
	int findIndexOfLastKey(int) const;
private:				// shouldNotImplement()
	virtual Object* addAfter(const Object& ob, Object& newob);
	virtual Object* addAllLast(const OrderedCltn&);
	virtual Object* addBefore(const Object& ob, Object& newob);
	virtual Object* addLast(Object& ob);
	virtual void atAllPut(Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
	virtual void sort();
};

#endif
