#ifndef	STACK_H
#define	STACK_H
                   
/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */                   
/* Stack.h,v 3.12 92/07/26 14:33:48 */

#include "nihclstd.h"
#pragma hdrstop

#include "OrderedC.h"

class Stack: public SeqCltn {
	DECLARE_MEMBERS(Stack);
	OrderedCltn contents;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Stack(unsigned size =DEFAULT_CAPACITY);
	Stack(const Stack&);
	bool operator==(const Stack& s) const
		{ return contents == s.contents; }
	bool operator!=(const Stack& s)	const { return !(*this==s); }
	Object*& operator[](int i)	{ return contents.at(size()-i-1); }
	const Object *const& operator[](int i) const	{ return contents.at(size()-i-1); }
	void push(Object& ob)		{ contents.addLast(ob); }
	Object* pop()			{ return contents.removeLast(); }
	Object* top() const		{ return contents.last(); }
	virtual Object* add(Object& ob);
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual unsigned long hash() const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual void reSize(unsigned newSize);
	virtual void removeAll();
	virtual Object* removeLast();
	virtual unsigned size() const;
private:			    // shouldNotImplement();
	virtual void atAllPut(Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual Object* remove(const Object&);
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
