/* HeapProc.c -- Implementation of Process with stack on free storage heap */   

/* MSDOS revisions - Michael F. Murphy 4/93 */
/* N.B. This version keeps SS==DS */
#ifndef _MSC_VER
#error Must have __near new operator
#endif

#ifdef MI
#error Doesn't work 
#endif

#include "nihclstd.h"
#pragma hdrstop

#include "HeapProc.h"
#include "Schedule.h"
#include "nihclIO.h"  

#define  THIS  HeapProc
#define  BASE  Process
#define  BASE_CLASSES BASE::desc()
#define  MEMBER_CLASSES
#define  VIRTUAL_BASE_CLASSES

extern const int NIHCL_BADTRACETBL,NIHCL_STACKOV;

DEFINE_ABSTRACT_CLASS(HeapProc,1,"",NULL);

HeapProc::HeapProc(const char* name, stackTy* bottom, int priority, unsigned /*long*/ size)
	: BASE(name, bottom, priority)
{
	stack_size = size; 
}

HeapProc::HeapProc(OIOifd& fd) : BASE(fd) {}

HeapProc::HeapProc(OIOin& strm) : BASE(strm) {}

HeapProc::~HeapProc()
{
	delete stack_bottom;
}

void HeapProc::setupStack()
{
	stackTy* top = topOfStack();
	stackTy* bottom = stack_bottom;
	stack_bottom = (stackTy __far *)new __near stackTy[stack_size];

#if STACK_GROWS_DOWN
	stack_bottom[0] = (stackTy)UNINITIALIZED;
	unsigned /*long*/ size = bottom-top;
	copyStack(top+1, stack_bottom+stack_size-size, size);
	 long delta = (stack_bottom+stack_size-1 - bottom) * sizeof(stackTy); 
#else
	stack_bottom[stack_size-1] = (stackTy)UNINITIALIZED;
	unsigned long size = top-bottom;
	copyStack(bottom, stack_bottom, size);
	long delta = (stack_bottom - bottom) * sizeof(stackTy);
#endif

	SETSP((unsigned long)((char*)SP() + delta)); // adjust stack pointer
	SETFP((unsigned long)((char*)FP() + delta)); // adjust frame pointer
}

unsigned HeapProc::size() const   { return stack_size; }

void HeapProc::switchContext(Process* new_process)
{
// check for stack overflow
#if STACK_GROWS_DOWN
	if (topOfStack() < stack_bottom || stack_bottom[0] != (stackTy)UNINITIALIZED)
		setError(NIHCL_STACKOV,DEFAULT,name());
#else
	if (topOfStack() >= stack_bottom+stack_size || stack_bottom[stack_size-1] != (stackTy)UNINITIALIZED)
		setError(NIHCL_STACKOV,DEFAULT,name());
#endif
	save();
	new_process->switchFrom(this);
}

void HeapProc::switchFrom(HeapProc*)
// switch from active HeapProc to next HeapProc
{
	LONGJMP(proc_env, Scheduler::resume_new_process);
}

void HeapProc::switchFrom(StackProc*)
// switch from active StackProc to next HeapProc
{
	LONGJMP(proc_env, Scheduler::resume_new_process);
}
