#ifndef HEAPPROC_H
#define HEAPPROC_H
             
/*NIH class library for MS-DOS 4/93 Michael F. Murphy*/
/*UNIX source:*/             
/*HeapProc.h,v 3.11 92/07/26 15:45:23*/

#include "nihclstd.h"
#pragma hdrstop

#pragma -vi
#include "NIHProc.h"

class HeapProc: public Process {
	DECLARE_MEMBERS(HeapProc);
	unsigned /*long*/ stack_size;	// size of stack in words
	void setupStack();
protected:
	HeapProc(const char* name, stackTy* bottom,
		int priority =0, unsigned /*long*/ size =1024);
	virtual void switchContext(Process*);
	virtual void switchFrom(HeapProc*);
	virtual void switchFrom(StackProc*);
	bool FORK() {  // MUST be inline - MFM
		add();		// add this process to Scheduler runlist
		if (_SETJMP(proc_env) == NULL) {
			setupStack();
			return YES;
		}
		else return NO;
	}
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd&) const	{ shouldNotImplement("storer"); }
	virtual	void storer(OIOout&) const	{ shouldNotImplement("storer"); }
public:
	virtual	void deepenShallowCopy()	{ shouldNotImplement("deepenShallowCopy"); }
public:
	~HeapProc();
	virtual unsigned size() const;
};

#endif  /* HEAPPROC_H */

