#ifndef  PROCESS_H
#define  PROCESS_H



/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * undo include <nihcl...
 * ulong hash()
 */
#pragma -vi
#include "nihclstd.h"
#pragma hdrstop

#include <assert.h>

#include "Link.h"
#include "NIHStrin.h"





const int MAXPRIORITY = 7; // maximum process priority

class Catch;
class ExceptionActionTbl;
class ExceptionEnv;
class HeapProc;
class Scheduler;
class Semaphore;
class StackProc;


class Process: public Link {
	DECLARE_MEMBERS(Process);
public:        // type definitions
	typedef /*long*/char  stackTy;   // long OK with __MS_DOS__ version of _STACKPROC_ALLOCATE
	enum processState { SUSPENDED, RUNNING, TERMINATED };
public:        // static member functions
	static void copyStack(const stackTy* src, stackTy* dst, unsigned /*long*/ count);
	static stackTy* topOfStack() {   // MUST be inline - MFM
		auto stackTy top;
		return &top;
	}
private:
	String process_name;
	processState process_state;   // SUSPENDED, RUNNING, or TERMINATED 
	ExceptionEnv* saved_exception_env_stack_top;
	ExceptionActionTbl* saved_exception_action;
	Catch* saved_catch_stack_top;    
	unsigned char process_priority;
protected:
	JMP_BUF proc_env;       // environment save structure for setjmp/longjmp
	stackTy* stack_bottom;  // pointer to stack bottom

	friend Scheduler;
	friend Semaphore;
protected:
	Process(const char* name, stackTy* bottom, int priority =0);
	Process(stackTy* bottom, int priority =0);   // MAIN Process constructor
	Process(const Process&);                     // shouldNotImplement()

	// MFM MS-DOS 
	unsigned long SETPC(unsigned long v)   { return SET_ENV_PC(v, proc_env); }
	unsigned long SETSP(unsigned long v)   { return SET_ENV_SP(v, proc_env); }
	unsigned long SETFP(unsigned long v)   { return SET_ENV_FP(v, proc_env); }
	unsigned long PC() const               { return GET_ENV_PC(proc_env); }
	unsigned long SP() const               { return GET_ENV_SP(proc_env); }
	unsigned long FP() const               { return GET_ENV_FP(proc_env); }

	void add();                            // add this process to Scheduler runlist
	virtual  void deepenShallowCopy();     // shouldNotImplement()
	virtual void restore();
	virtual void save();
	virtual void storer(OIOofd&) const;    // shouldNotImplement()
	virtual void storer(OIOout&) const;    // shouldNotImplement()
	virtual void switchContext(Process*) = 0;
public:
	~Process();
	const char* name() const   { return process_name; }
	processState state() const { return process_state; }

	virtual unsigned capacity() const;        // returns stack size
	virtual int compare(const Object&) const; // compare process priorities 
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object& ob) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned char priority() const;
	virtual unsigned char priority(unsigned char newPriority);
	virtual void resume();
#ifndef LINKPUREVIRT
	virtual unsigned size() const = 0;
#else
	virtual unsigned size() const { assert(0); abort(); return 0; }   
#endif
	virtual void suspend();
	virtual void switchFrom(HeapProc*) = 0;
	virtual void switchFrom(StackProc*) = 0;
	virtual void terminate();
private:          // shouldNotImplement()
	virtual Object* copy() const;
};

#endif
