/* Scheduler.c -- implementation of the Process Scheduler


Class Scheduler provides an interface to the single instance of the
process scheduler, scheduler.

*/                                   
#include "nihclstd.h"
#pragma hdrstop

#pragma -vi
#include "NIHProc.h"
#include "Schedule.h"

JMP_BUF  Scheduler::switcher;                         // environment for stack switcher
Process* Scheduler::active_process = /*NULL*/0UL;
Process* Scheduler::previous_process = /*NULL*/0UL;
StackProc* Scheduler::main_stack_process = /*NULL*/0UL;
Process::stackTy* Scheduler::main_stack_bottom = /*NULL*/0UL;
unsigned Scheduler::runCount = 0;                     // total # of runnable processes
LinkedList Scheduler::runList[MAXPRIORITY+1];


void Scheduler::addProcess(Process& p)
{
	p.process_state = Process::RUNNING;
	runList[p.process_priority].addLast(p);
	runCount++;
}

void Scheduler::schedule()
{
	 setjmp_val val = (setjmp_val)SETJMP(active_process->proc_env);

	 while (YES) {
	switch (val) {
		 case schedule_process: {
			while (runCount>0) {
				for (int i=MAXPRIORITY; i>=0; i--) {
					if (runList[i].size() > 0) {
						Process* active = active_process;
						Process* next = Process::castdown(runList[i].first());
						if (active != next) {
							previous_process = active;
							active_process = next;
							active->switchContext(next);
						}
					LONGJMP(next->proc_env, resume_current_process);
					}
				}
			}

		break;   // schedule process
		}

		 case resume_current_process: {
			return;
		 }
		 case resume_new_process: {
			active_process->restore();
			return;
		}
	}
	 }
}


void Scheduler::yield()
{
	if (runList[activePriority()].size() == 1) schedule();
	else {
		activeProcess().suspend();
		activeProcess().resume();
	}
}

const char* Scheduler::className()  { return "Scheduler"; }

void Scheduler::dumpOn(ostream& strm)
{
	strm << className()
		<< "[active process: "
		<< (active_process ? active_process->name() : "NONE")
		<< "  previous process: "
		<< (previous_process ? previous_process->name() : "NONE")
		<< '\n';
	strm << "runList:\n";
	for (unsigned i =MAXPRIORITY; i>=0; i--) {
		DO(runList[i],Process,p) p->dumpOn(strm); OD
	}

	strm << "]\n";
}

void Scheduler::printOn(ostream& strm)
{
	strm << className()
		<< "  active process: " << active_process->name()
		<< "  previous process: " << previous_process->name() << '\n';
	strm << "runList:";
	for (unsigned i =MAXPRIORITY; i>=0; i--) {
		DO(runList[i],Process,p) strm << ' ' << *p; OD
	}
	strm << '\n';


}
