#ifndef	SCHEDULER_H
#define	SCHEDULER_H

/*NIH class library for MS-DOS 4/93 Michael F. Murphy*/
/*UNIX source:*/  
/*Scheduler.h,v 3.11 92/07/26 15:45:27*/     

#include "nihclstd.h"
#pragma hdrstop
            
#pragma -vi
            
#include "LinkedLi.h"
#include "StackPro.h"



class HeapProc;

class Scheduler : public NIHCL {
public:			// type definitions
	enum setjmp_val { schedule_process=0, resume_current_process, resume_new_process };
public:			// static member functions
	static unsigned char activePriority()	{ return active_process->priority(); }
	static Process& activeProcess()		{ return *active_process; }
	static const char* className();
	static void dumpOn(ostream& strm =cerr);
	static void initialize(Process::stackTy* bottom, int priority =0);
	static void printOn(ostream& strm =cout);
	static void terminateActive()		{ activeProcess().terminate(); }
	static void schedule();
	static void yield();
public:			// static member variables
	static JMP_BUF switcher;	// environment for stack switcher
// The following must be public so they can be accessed from the MAIN_PROCESS macro
	static Process* active_process;
	static StackProc* main_stack_process;
	static Process::stackTy* main_stack_bottom;
private:		// static member variables
	static Process* previous_process;
	static unsigned runCount;	// total # of runnable processes 
	static LinkedList runList[MAXPRIORITY+1];
protected:		// static member variables
	Scheduler() {}		// to prevent construction of instances
private:		// member functions
	Scheduler(const Scheduler&) {}	// to prevent copy of instances
	static void addProcess(Process& p);
	friend Process;
	friend StackProc::StackProc(stackTy* bottom, int priority);
	friend void StackProc::switchFrom(HeapProc*);
	friend void StackProc::switchFrom(StackProc*);
};

inline void Scheduler::initialize(Process::stackTy* bottom, int priority)
{
	Scheduler::main_stack_bottom = bottom;
// Create MAIN process
	Scheduler::active_process = new StackProc(bottom,priority);
}

/*
main() must call MAIN_PROCESS first thing to initialize the scheduler.

Note: MAIN_PROCESS must avoid using blocks in code executed as the
result of a longjmp() because such blocks may contain
compiler-generated local variables that share storage with local
variables used elsewhere in main().  Executing such a block after a
longjmp() would cause these local variables to be overwritten.  Inline
functions must be avoided for the same reason.

*/
#pragma -vi

#define _STACKTY Process::stackTy

#ifndef __MS_DOS__
#define _STACKPROC_ALLOCATE(active) \
	alloca((size_t)(Scheduler::main_stack_bottom - (active)->stack_top) * sizeof(_STACKTY))\

#else
// straight subtraction - MFM
#define _STACKPROC_ALLOCATE(active) \
	alloca((size_t)((char*)Scheduler::main_stack_bottom - (char*)((active)->stack_top)))\
    
#endif    

#define MAIN_PROCESS(priority) \
	if (_SETJMP(Scheduler::switcher) == 0) goto _begin_main_process; \
/* longjmp() here to restore a process's stack */ \
	((StackProc*)Scheduler::active_process)-> \
		restoreStack((_STACKTY*)_STACKPROC_ALLOCATE((StackProc*)Scheduler::active_process)); \
_begin_main_process: \
	Scheduler::initialize((_STACKTY*)alloca(sizeof(_STACKTY)),priority); \


#endif /* SCHEDULER_H */


