#ifndef	SHAREDQUEUE_H
#define	SHAREDQUEUE_H  

/*NIH class library for MS-DOS 4/93 Michael F. Murphy*/
/*Unix source:*/
/*SharedQueue.h,v 3.11 92/07/26 15:45:30*/


#include "nihclstd.h"
#pragma hdrstop
 
#pragma -vi 
#include "ArrayOb.h"
#include "Semaphor.h"



class SharedQueue: public VIRTUAL Object {
	DECLARE_MEMBERS(SharedQueue);
	ArrayOb queue;
	int readPosition,writePosition;
	Semaphore valueAvailable;
	Semaphore spaceAvailable;
protected:	// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	SharedQueue(unsigned queueSize = Collection::DEFAULT_CAPACITY);
	SharedQueue(const SharedQueue&);
	bool isFull() const	{ return spaceAvailable.value() == 0; }
	virtual unsigned capacity() const;
	virtual Object* copy() const;	// deepCopy()
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm = cerr) const;
	virtual unsigned long hash() const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual Object* next();
	virtual Object* nextPut(Object&);
	virtual void printOn(ostream& strm = cout) const;
	virtual unsigned size() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif	/* SHAREDQUEUE_H */
