/* StackProc.c -- Implementation of Process with stack shared with main() process
*/     

#include "nihclstd.h"
#pragma hdrstop

#pragma -vi
#include "StackPro.h"
#include "Schedule.h"
#include "nihclIO.h"

#define  THIS  StackProc
#define  BASE  Process
#define  BASE_CLASSES BASE::desc()
#define  MEMBER_CLASSES
#define  VIRTUAL_BASE_CLASSES

DEFINE_ABSTRACT_CLASS(StackProc,1,"",NULL);

StackProc::StackProc(const char* name, stackTy* bottom,
							int priority, unsigned /*long*/ size)
	: BASE(name, bottom, priority)
{
	stack_top = topOfStack();         // right here MFM
	stack_save_size = size;
	if (size != 0)
		stack_save = new stackTy[size];
	else
		stack_save = /*NULL*/0UL;
	saveStack();
}

StackProc::StackProc(stackTy* bottom, int priority)
	: BASE(bottom, priority)
// contructor for MAIN process
{
	stack_top = bottom;
	stack_save = /*NULL*/0UL;
	stack_save_size = 0;
	Scheduler::main_stack_process = this;
	add();         // add MAIN process to Scheduler runlist
}

StackProc::StackProc(OIOifd& fd) : BASE(fd) {}

StackProc::StackProc(OIOin& strm) : BASE(strm) {}

StackProc::~StackProc()
{
	delete stack_save;
}

void StackProc::saveStack()
// save the stack for this Process
{
	unsigned /*long*/ size = (unsigned)(stack_bottom - stack_top);
	if (stack_save_size < size) {
		if (stack_save_size != 0) delete stack_save;
		stack_save = new stackTy[size];
		stack_save_size = size;
	}
	copyStack(stack_top+1, stack_save, size);
}

void StackProc::restoreStack(const stackTy* palloc)
{
	Scheduler::main_stack_process = (StackProc*)Scheduler::active_process;

	if (palloc != stack_top+1) {
		// print out the offending pointers - MFM
		cerr << "\npalloc " <<(void*)palloc << " stack_top+1 " << (void*)(stack_top+1) << endl;
		cerr << "StackProc::restoreStack() assertion failed\n";
		abort();
	}
	copyStack(stack_save, stack_top+1, (unsigned)(stack_bottom-stack_top));
	LONGJMP(((StackProc*)Scheduler::active_process)->proc_env, Scheduler::resume_new_process);
}

unsigned StackProc::size() const
{
	return (unsigned)(stack_bottom - stack_top);
}

void StackProc::switchContext(Process* new_process)
{
	stack_top = topOfStack();    // right here - MFM
	save();
	new_process->switchFrom(this);
}

void StackProc::switchFrom(HeapProc*)
// switch from active HeapProc to next StackProc
{
	if (Scheduler::main_stack_process == this)
		LONGJMP(proc_env, Scheduler::resume_new_process);
	Scheduler::main_stack_process->saveStack();
	_LONGJMP(Scheduler::switcher, 1);
}

void StackProc::switchFrom(StackProc* active)
// switch from active StackProc to next StackProc
 {
	active->saveStack();
	_LONGJMP(Scheduler::switcher, 1);     // resume_current_process
}
