// ex11-1.c -- Scheduling lightweight processes in
//             the NIH class library

#define BASE StackProc
#if BASE == StackProc
#include "StackPro.h"
#endif
#if BASE == HeapProc
#include "HeapProc.h"
#endif

#include "Schedule.h"
#include "Semaphor.h"
#include "NIHStrin.h"

class TestProcess : public BASE {
public:
    TestProcess(const char* name, stackTy* bot, int pri,
                Process* parent);
    static TestProcess* create(const char* name, int pri,
                               Process* parent);
};

TestProcess::TestProcess(const char* pname,stackTy* bot,int pri,
                         Process* parent)
            : BASE(pname,bot,pri)
{
    // parent process yields to allow this process to start
    if ( FORK() ) { Scheduler::yield(); return; }

    cout << name() << pri << " start" << endl;

    // yield to parent process
    if (parent) {
        parent->resume();
        Scheduler::yield();
        }
    // suspend until child yields
    suspend();
    Scheduler::schedule();

    cout << name() << pri << " resume" << endl;

    // terminate to avoid return
    terminate();
}

TestProcess* TestProcess::create(const char* name, int pri,
                                 Process* parent)
{
    // the next two statements must be in the same scope
    // for the address of the stack bottom to be correct
    auto Process::stackTy bottom;
    return new TestProcess(name,&bottom,pri,parent);
}

void main()
{
    // start Scheduler
    // create main context with priority 0
    MAIN_PROCESS(0);

    Process* parent =0;
    String* pname = new String("P"); 
    for (register int i=MAXPRIORITY; i>=1; i--)
        parent = TestProcess::create(*pname,i,parent);

    cout << "main Process" << endl;
    parent->resume();
    Scheduler::yield();
}
