/* Test class Process
*/

#include <assert.h>

#include "StackPro.h"
#include "HeapProc.h"
#include "SharedQu.h"
#include "Schedule.h"
#include "NIHStrin.h"

class TestStackProc : public StackProc {
protected:
	TestStackProc(const char* name, stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out);
public:
	static TestStackProc* create(const char* name, int pri, SharedQueue& in, SharedQueue& out);
};

TestStackProc::TestStackProc(const char* pname, stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out)
	: StackProc(pname,bottom,pri)
{
	if (FORK()) return;
	while (YES) {
		Object* msg = in.next();
		cout << "StackProc " << name() << " received " << *msg << endl;
		out.nextPut(*msg);
		cout << "StackProc " << name() << " sent " << *msg << endl;
	}
}

TestStackProc* TestStackProc::create(const char* name, int pri, SharedQueue& in, SharedQueue& out)
{
	auto Process::stackTy bottom;
	return new TestStackProc(name, &bottom, pri, in, out);
}

class TestHeapProc : public HeapProc {
protected:
	TestHeapProc(const char* name, Process::stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out);
public:
	static TestHeapProc* create(const char* name, int pri, SharedQueue& in, SharedQueue& out);
};

TestHeapProc::TestHeapProc(const char* pname, Process::stackTy* bottom, int pri, SharedQueue& in, SharedQueue& out)
	: HeapProc(pname,bottom,pri)
{
	if (FORK()) return;
	while (YES) {
		Object* msg = in.next(); 
		assert(msg);
		cout << "HeapProc  " << name() << " received " << *msg << endl;
		out.nextPut(*msg);
		cout << "HeapProc  " << name() << " sent " << *msg << endl;
	}
}

TestHeapProc* TestHeapProc::create(const char* name, int pri, SharedQueue& in, SharedQueue& out)
{
	auto Process::stackTy bottom;
	return new TestHeapProc(name, &bottom, pri, in, out);
}

void main()
{
	MAIN_PROCESS(0);
	SharedQueue* q0 = new SharedQueue(2);
	SharedQueue* qin = q0;
	SharedQueue* qout;
	for (int i=1; i<= /*MAXPRIORITY*/1; i++) {
		String pname = "P";
		pname &= (char)('0'+i);
		qout = new SharedQueue(2);
		/*if (i & 2)*/ 
			TestHeapProc::create(pname,i,*qin,*qout);
		//else TestStackProc::create(pname,i,*qin,*qout);
		qin = qout;
	}
	String& msg = *new String("THE MESSAGE");
	Scheduler::dumpOn(cerr);
	q0->dumpOn(cerr);
	Scheduler::yield();
	q0->nextPut(msg);
	cout << *qout->next() << endl;
}
