/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */
/* ArrayOb.c,v 3.15 92/09/11 12:33:40 */

#include "nihclstd.h"
#pragma hdrstop

#include <ArrayOb.h>
#include <nihclIO.h>

#define DEBUG
#include <assert.h>

#define	THIS	ArrayOb
#define	BASE	Collection
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(ArrayOb,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_ALLOCSIZE,NIHCL_INDEXRANGE;      

/*
Note: we use malloc()/free() here instead of new/delete because
we use realloc() to implement reSize().
*/                 
                            
// Which is why <assert.h> is here! (better to seterror(NIHCL_ALLOCFAIL) in production) -  MFM 

#define NEW(type,size)	((type*)malloc(sizeof(type)*(size)))

inline void DELETE(Object** ptr) { free((char*)ptr); }

inline Object** REALLOC(Object** ptr, unsigned size)
{
	return (Object**)realloc((char*)ptr,sizeof(Object*)*size);
}

ArrayOb::ArrayOb(unsigned size)
{
	sz = size;
	if (sz==0) allocSizeErr();
	v = NEW(Object*,sz);
	assert(v != NULL);
	unsigned i = sz;
	Object** vp = v;
	while (i--) *vp++ = nil;
	
}
	
ArrayOb::ArrayOb(const ArrayOb& a)
{
	int i = a.sz;
	sz = i;
	v = NEW(Object*,i);
	assert(v != NULL);
	Object** vp = v;
	Object** av = a.v;
	while (i--) *vp++ = *av++;
}

ArrayOb::~ArrayOb()	{ DELETE(v); }

void ArrayOb::operator=(const ArrayOb& a)
{
	if (v != a.v) {
		DELETE(v);
		v = NEW(Object*,sz=a.sz);
		assert(v != NULL);
		int i = a.sz;
		Object** vp = v;
		Object** av = a.v;
		while (i--) *vp++ = *av++;
	}
}

bool ArrayOb::operator==(const ArrayOb& a) const
{
	if (sz != a.sz) return NO;
	unsigned i = sz;
	Object** vp = v;
	Object** av = a.v;
	while (i--) { if (!((*vp++)->isEqual(**av++))) return NO; }
	return YES;
}

Object*& ArrayOb::at(int i)			{ return (*this)[i]; }

#ifdef REFTOTEMP
// add cast
const Object *const& ArrayOb::at(int i) const
	{ return (const Object *const&)((*this)[i]); }
#else
const Object *const& ArrayOb::at(int i) const	{ return (*this)[i]; }
#endif

unsigned ArrayOb::capacity() const	{ return sz; }
	
bool ArrayOb::isEqual(const Object& a) const
{
	return a.isSpecies(classDesc) && *this==castdown(a);
}

const Class* ArrayOb::species() const { return &classDesc; }

void ArrayOb::reSize(unsigned newsize)
{
	if (newsize == 0) allocSizeErr();
	v = REALLOC(v,newsize);
	assert(v != NULL);
	if (newsize > sz) {	// initialize new space to nil
		Object** vp = &v[sz];
		while (newsize > sz) {
			*vp++ = nil;
			sz++;
		}
	}
	else sz = newsize;
	
}

void ArrayOb::removeAll()
{
	Object** vp = v;
	unsigned i = sz;
	while (i--) *vp++ = nil;
}

Collection& ArrayOb::addContentsTo(Collection& cltn) const
{
	Object** vp = v;
	unsigned i = sz;
	while (i--) cltn.add(**vp++);
	return cltn;
}

Object* ArrayOb::doNext(Iterator& pos) const
{
	if (pos.index < size()) return v[pos.index++];
	return NULL;
}

void ArrayOb::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	int i = sz;
	Object** vp = v;
	while (i--) {
		*vp = (*vp)->deepCopy();
		vp++;
	}
}

unsigned long ArrayOb::hash() const
{
	unsigned long h = sz;
	unsigned i = sz;
	Object** vp = v;
	while (i--) h^=(*vp++)->hash();
	return h;
}

ArrayOb::ArrayOb(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	strm >> sz;
	v = NEW(Object*,sz);
	assert(v != NULL);
	for ( unsigned i=0; i<sz; i++) v[i] = Object::readFrom(strm);
}

void ArrayOb::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << sz;
	for ( unsigned i=0; i<sz; i++) v[i]->storeOn(strm);
}

unsigned ArrayOb::size() const	{ return sz; }

static int compare_ob(const void* a, const void* b)
{
	return (*(const Object**)a)->compare(**(const Object**)b);
}

void ArrayOb::sort()
{
	qsort(v,sz,sizeof(Object*),compare_ob);
}

void ArrayOb::allocSizeErr() const
{
	setError(NIHCL_ALLOCSIZE,DEFAULT,this,className());
}

void ArrayOb::indexRangeErr() const
{
	setError(NIHCL_INDEXRANGE,DEFAULT,this,className());
}

ArrayOb::ArrayOb(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	fd >> sz;
	v = NEW(Object*,sz);
	assert(v != NULL);
	for ( unsigned i=0; i<sz; i++ )
	   v[i] = Object::readFrom(fd);
}

void ArrayOb::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << sz;
	for ( unsigned i=0; i<sz; i++) 
		v[i]->storeOn(fd);
}

int ArrayOb::compare(const Object& arg) const
// Compare two arrays of objects.  If *this > arg return >0,
// *this == arg return 0, and if *this < arg return <0.
{
	assertArgSpecies(arg,classDesc,"compare");
	const ArrayOb& a = castdown(arg);
	for (unsigned int i=0; i<sz; i++) {                 // MFM unsigned
// previous elements compared equal; longer ArrayOb is therefore larger
		if (i == a.sz) return 1;
// compare() != 0 at any element determines ordering
		int val;
		if ((val = v[i]->compare(*a.v[i])) != 0) return val;
	}
// all elements in this ArrayOb compare() equal to arg ArrayOb
	if (sz == a.sz) return 0;
	return -1;
}

Object* ArrayOb::add(Object& ob)
{
	shouldNotImplement("add");
	return &ob;
}

unsigned ArrayOb::occurrencesOf(const Object&) const
{
	shouldNotImplement("occurrencesOf");
	return 0;
}

Object* ArrayOb::remove(const Object&)
{
	shouldNotImplement("remove");
	return 0;
}
