/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */
/* Assoc.c,v 3.13 92/12/19 15:52:46 */

#include "nihclstd.h"
#pragma hdrstop

#include <Assoc.h>
#include <nihclIO.h>

#define	THIS	Assoc
#define	BASE	LookupKey
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Assoc,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

Assoc::Assoc(Object& newKey, Object& newValue) : BASE(newKey)
{
	avalue = &newValue;
}

#ifdef BADDEFAULTFCNS
Assoc::Assoc(const Assoc& copyfrom): BASE(copyfrom), avalue(copyfrom.avalue)
{
}

Assoc& Assoc::operator=(const Assoc& rhs)
{
	if(this == &rhs)
		return *this;

	BASE::operator=(rhs);

	avalue = rhs.avalue;
	return *this;
}
#endif


Object* Assoc::value() { return avalue; }

const Object* Assoc::value() const { return avalue; }

Object* Assoc::value(Object& newvalue)
{
	Object* temp = avalue;
	avalue = &newvalue;
	return temp;
}

void Assoc::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	avalue = avalue->deepCopy();
}

Assoc::Assoc(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	avalue = Object::readFrom(strm);
}

void Assoc::storer(OIOout& strm) const
{
	BASE::storer(strm);
	avalue->storeOn(strm);
}

Assoc::Assoc(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	avalue = Object::readFrom(fd);
}

void Assoc::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	avalue->storeOn(fd);
}
