/* Bag.c,v 3.14 92/07/26 14:31:53 */
/* Bag.c -- implementation of a Set of Objects with possible duplicates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!kgorlen
	Internet: kgorlen@alw.nih.gov
	September, 1985

Function:
	
A Bag is like a Set, except Bags can contain multiple occurrences of
equal objects.  Bags are implemented by using a Dictionary to associate
each object in the Bag with its number of occurrences.

$Log:	Bag.c,v $
 * Revision 3.14  92/07/26  14:31:53  sandy
 * include directive in form '#include <nihcl/foo.h>'
 * 
 * Revision 3.13  92/06/17  11:35:20  sandy
 * __DECCCXX compatible
 * 
 * Revision 3.12  92/04/30  15:47:34  sandy
 * one initor in DEFINE_CLASS macros
 *
 * Revision 3.11  91/07/16  13:17:27  kgorlen
 * Implement _reader() functions.
 *
 * Revision 3.10  91/02/18  21:05:49  kgorlen
 * Release for 3rd printing of 1st edition.
 * 
 * Revision 3.1  91/02/07  12:11:38  kgorlen
 * Cast occurrence count to unsigned in storer() functions.
 * 
 * Revision 3.0  90/05/20  00:19:06  kgorlen
 * Release for 1st edition.
 *
*/
/* MSDOS revisions - Michael Murphy 1993
 * unsigned long hash()
 * pragmas
 * 0 to NULL
 * recodings for no warnings
 */
#include "nihclstd.h"
#pragma hdrstop

#include <Bag.h>
#include <AssocInt.h>
#include <Integer.h>
#include <nihclIO.h>

#define	THIS	Bag
#define	BASE	Collection
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES Dictionary::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Bag,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_REMOVEERR;

Bag::Bag(unsigned size) : contents(size)
{
	count = 0;
}

Bag::Bag(const Bag& b) : contents(b.contents)
{
	count = b.count;
	Object* a;
	Iterator i(contents);
	while ((a = i++) != NULL) {		//MFM
		contents.at(i.index-1) = a->shallowCopy();
	}
}

Bag::~Bag()
{
	DO(contents,AssocInt,a) delete a; OD;
}

void Bag::operator=(const Bag& b)
{
	if (this == &b) return;
	DO(contents,AssocInt,a) delete a; OD;
	contents = b.contents;
	count = b.count;
	Object* a;
	Iterator i(contents);
	while ((a = i++) != NULL) 	// MFM
		contents.at(i.index-1) = a->shallowCopy();
}

void Bag::reSize(unsigned newSize)
{
	contents.reSize(newSize);
}

Object* Bag::addWithOccurrences(Object& ob, unsigned n)
{
	AssocInt* a = (AssocInt*)contents.assocAt(ob);
	Object* o = &ob;
	if (a == NULL) {
	        a = new AssocInt(ob,n);
		contents.add(*a);
	}
	else {
		Integer& i = *Integer::castdown(a->value());
		o = a->key();
		i.value(i.value()+n);
	}
	count += n;
	return o;
}

Object* Bag::add(Object& ob)
{
	return addWithOccurrences(ob,1);
}

Object*& Bag::at(int i)	    			{ return contents.at(i); }

const Object *const& Bag::at(int i) const      { return contents.at(i); }

unsigned Bag::capacity() const { return contents.capacity(); }

void Bag::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	contents.deepenShallowCopy();
}
 
#pragma warning (disable: 4127) 
Object* Bag::doNext(Iterator& pos) const
{
	const AssocInt* a;
	while (YES) {
		if (pos.num == 0) {
			a = AssocInt::castdown(contents.doNext(pos));
			if (a == NULL) return NULL;
		}
		else a = AssocInt::castdown(contents.at(pos.index-1));
		if ((int)pos.num++ < (Integer::castdown(a->value()))->value())  // (int) MFM
			return a->key();
		pos.num = 0;
	}
}                          
#pragma warning (default: 4127) 

void Bag::dumpOn(ostream& strm) const
{
	strm << className() << '[';
	DO(contents,AssocInt,a) a->dumpOn(strm); OD
	strm << "]\n";
}

Object* Bag::remove(const Object& ob)
{
	AssocInt* a = (AssocInt*)contents.assocAt(ob);
	Object* rob = NULL;		// return NULL until last occurrence removed
	if (a == NULL) setError(NIHCL_REMOVEERR,DEFAULT,this,className(),ob.className(),&ob);
	Integer* i = Integer::castdown(a->value());
	unsigned n = (unsigned)(i->value());
	if (--n == 0) {
		rob = a->key();
		delete AssocInt::castdown(contents.remove(*a));
	}
	else i->value(n);
	--count;
	return rob;
}

void Bag::removeAll()
{
	DO(contents,AssocInt,a) delete a; OD;
	contents.removeAll();
	count = 0;
}

bool Bag::operator==(const Bag& b) const
{
	return count==b.count && contents==b.contents;
}

unsigned long Bag::hash() const	{ return count^contents.hash(); }

bool Bag::isEqual(const Object& p) const
{
	return p.isSpecies(classDesc) && *this==castdown(p);
}

const Class* Bag::species() const { return &classDesc; }

unsigned Bag::occurrencesOf(const Object& ob) const
{
	AssocInt* a = (AssocInt*)contents.assocAt(ob);
	if (a == NULL)
		return 0;
	else
		return (unsigned)((Integer::castdown(a->value()))->value()); //MFM
}

unsigned Bag::size() const	{ return count; }

Bag Collection::asBag() const
{  unsigned t_size = MAX(size(),DEFAULT_CAPACITY);
	Bag cltn(t_size);
	addContentsTo(cltn);
	return cltn;
}

void Bag::_reader(OIOin& strm)
/*
  Since addWithOccurrences() is virtual, calling it from a base class constructor
  will bind to the wrong implementation, so call it only if this
      is the constructor for the most-derived class.
*/
{
    if (strm.readFromClass() == isA()) {
	unsigned i,n;
	strm >> n;		// read bag size 
	while (n--) {
	    strm >> i;
	    addWithOccurrences(*Object::readFrom(strm),i);
	}
    }
}

void Bag::_reader(OIOifd& fd)
{
    if (fd.readFromClass() == isA()) {
	unsigned i,n;
	fd >> n;
	while ( n-- ) {
	    fd >> i;
	    addWithOccurrences(*Object::readFrom(fd),i);
	}
    }
}

static unsigned bag_capacity;

Bag::Bag(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	contents((strm >> bag_capacity, bag_capacity))
{
	count = 0;
	_reader(strm);
}

void Bag::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << contents.capacity() << contents.size();
	DO(contents,AssocInt,a)
		strm << (unsigned)(Integer::castdown(a->value()))->value();
		(a->key())->storeOn(strm);
	OD
}

Bag::Bag(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	contents((fd >> bag_capacity, bag_capacity))
{
	count = 0;
	_reader(fd);
}

void Bag::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << contents.capacity() << contents.size();
	DO(contents,AssocInt,a)
		fd << (unsigned)(Integer::castdown(a->value()))->value();
		(a->key())->storeOn(fd);
	OD
}

int Bag::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
