/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: */
/* BitBoard.c,v 3.13 92/12/19 15:52:51 */
#include "nihclstd.h"
#pragma hdrstop

#include "BitBoard.h"
#include "nihclIO.h"

#define	THIS	BitBoard
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(BitBoard,1,"$"__FILE__" "__DATE__" "__TIME__"$",BitBoard::init)

BitBoard squareBitBoard[64];
BitBoard rankBitBoard[8];
BitBoard fileBitBoard[8];
unsigned char bit_count[256];

void BitBoard::init(const Class&)
{
	BitBoard* p = squareBitBoard;
	unsigned i,j,k;
	for (i=0; i<8; i++) {
		for (j=0, k=1; j<8; j++, k+=k) {
			(*p++).c[i] = (unsigned char)k;  // (unsigned char) MFM
		}
	}
	p = rankBitBoard;
	BitBoard* q = fileBitBoard;
	for (i=0, k=1; i<8; i++, k+=k) {
		(*p++).c[i] = 0xFF;
		for (j=0; j<8; j++) {
			(*q).c[j] = (unsigned char)k;    // (unsigned char) MFM	
		}
		q++;
	}
}

unsigned BitBoard::capacity() const { return sizeof(BitBoard)*8; }

void BitBoard::deepenShallowCopy()	{}

unsigned long BitBoard::hash() const { return m[0]^m[1]; }
	
bool BitBoard::isEmpty() const { return m[0]==0 && m[1]==0; }
	
bool BitBoard::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* BitBoard::species() const { return &classDesc; }

void BitBoard::printOn(ostream& strm) const
{
	for (int i=0; i<8; i++) {
		strm << '\n';
		for (int j=7; j>=0; j--) {
			if (includes(8*i+j)) strm << " *";
			else strm << " .";
		}
	}
}		

unsigned BitBoard::size() const	{ return count(); }

BitBoard::BitBoard(OIOin& strm)
	: BASE(strm)
{
	strm >> m[0] >> m[1];
}

void BitBoard::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << m[0] << m[1];
}

BitBoard::BitBoard(OIOifd& fd)
	: BASE(fd)
{
	fd.get((char*)c,8);
}

void BitBoard::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd.put((char*)c,8);
}

int BitBoard::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
