/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Dictionary.c,v 3.14 92/12/19 15:52:59 */
#include "nihclstd.h"
#pragma hdrstop

#include <Dictiona.h>
#include <LookupKe.h>
#include <Assoc.h>
#include <nihclIO.h>

#define	THIS	Dictionary
#define	BASE	Set
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Dictionary,0,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

extern const int NIHCL_DUPKEY,NIHCL_KEYNOTFOUND;

Dictionary::Dictionary(unsigned size) : BASE(size) {}

bool Dictionary::operator==(const Dictionary& d) const
{
	if (size() != d.size()) return NO;
	DO(*this,LookupKey,a) if (!d.includesAssoc(*a)) return NO; OD
	return YES;
}

Object* Dictionary::add(Object& ob)
{
	assertArgClass(ob,*LookupKey::desc(),"add");
	return Set::add(ob);
}

Assoc* Dictionary::addAssoc(Object& key, Object& value)
{
	Assoc* a = new Assoc(key,value);
	Assoc* b = Assoc::castdown(Set::add(*a));
	if (a != b) {
		delete a;
		setError(NIHCL_DUPKEY,DEFAULT,this,className(),"addAssoc",key.className(),&key);
	}
	return b;
}

Collection& Dictionary::addContentsTo(Collection& cltn) const
{
	DO(*this,LookupKey,a) cltn.add(*(a->value())); OD
	return cltn;
}

Object* Dictionary::remove(const Object& ob)
{
	assertArgClass(ob,*LookupKey::desc(),"remove");
	return Set::remove(ob);
}

Object* Dictionary::atKey(const Object& key) const
{
	Object* p = findObjectWithKey(key);
	if (p==nil) {
		setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
		/* not reached */
		return LookupKey::castdown(p)->value();
	}
	else return LookupKey::castdown(p)->value();
}

Object* Dictionary::atKey(const Object& key, Object& newValue)
{
	Object* p = findObjectWithKey(key);
	if (p==nil) {
		setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
		/* not reached */
		return LookupKey::castdown(p)->value(newValue);
	}
	else return LookupKey::castdown(p)->value(newValue);
}

LookupKey* Dictionary::assocAt(const Object& key) const
{
	Object* lk = findObjectWithKey(key);
	if (lk == nil) return NULL;
	return LookupKey::castdown(lk);
}

Collection& Dictionary::addKeysTo(Collection& cltn) const
{
	DO(*this,LookupKey,a) cltn.add(*a->key()); OD
	return cltn;
}

Collection& Dictionary::addValuesTo(Collection& cltn) const
{
	return addContentsTo(cltn);
}

Object* Dictionary::keyAtValue(const Object& val) const
{
	DO(*this,LookupKey,a) if (val.isEqual(*a->value())) return a->key(); OD
	return nil;
}

unsigned Dictionary::occurrencesOf(const Object& val) const
{
	unsigned n =0;
	DO(*this,LookupKey,a) if (val.isEqual(*a->value())) n++; OD
	return n;
}

bool Dictionary::includesAssoc(const LookupKey& asc) const
{
	Object* p = findObjectWithKey(asc);
	if (p==nil) return NO;
	return asc.value()->isEqual(*(LookupKey::castdown(p)->value()));
}

bool Dictionary::includesKey(const Object& key) const
{
	if (findObjectWithKey(key) == nil) return NO;
	else return YES;
}

bool Dictionary::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Dictionary::species() const { return &classDesc; }

LookupKey* Dictionary::removeAssoc(const LookupKey& asc)
{
	return LookupKey::castdown(Set::remove(asc));
}

LookupKey* Dictionary::removeKey(const Object& key)
{
	LookupKey* lk = assocAt(key);
	if (lk == NULL) setError(NIHCL_KEYNOTFOUND,DEFAULT,this,className(),key.className(),&key);
	return removeAssoc(*lk);
}

Dictionary::Dictionary(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	_reader(fd);
}

Dictionary::Dictionary(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	_reader(strm);
}

int Dictionary::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
