/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Exception.c,v 3.15 92/07/26 14:32:14 */
/*
 * support for P error report (pointer value)
 */

#include "nihclstd.h"
#pragma hdrstop

#include "ExceptAc.h"

#include <stdarg.h>
#include <errno.h>  

#include "errlib.h"
#include "nihclcon.h"
#include "niherrs.h"        


#include <niherrsx.h> // the initialization of the error numbers - MFM


ExceptionEnv* ExceptionEnv::stackTop = NULL;
ExceptionEnv* ExceptionEnv::lastResort = NULL;
static ExceptionEnv topExceptionEnv;

static Catch topCatch;
Catch* Catch::stackTop = &topCatch;


void ExceptionEnv::raise(int exception)
{
	if (exception == 0) {
		cerr << "Tried to RAISE exception code 0\n";
		abort();
	}
	if (prev == NULL) {	// i.e.,  this == lastResort
		cerr << "NIHCL: fatal: Unhandled exception code " << exception << '\n';
		exit(1);
	}
	pop();
#if STACK_GROWS_DOWN
	for (register Catch* p = Catch::stackTop->next; p < (Catch*)this && p != Catch::stackTop; p = p->next) {
#else
	for (register Catch* p = Catch::stackTop->next; p > (Catch*)this && p != Catch::stackTop; p = p->next)
#endif
		p->obj->destroyer();  
	}		
	Catch::stackTop->next = p;
	p->prev = Catch::stackTop;
	longjmp(env,exception);
}

Catch::Catch()
{
	next = prev = this;
	obj = Object::nil;
}

Catch::Catch(Object* ob)
{
	obj = ob;
	void* top[2];
#if STACK_GROWS_DOWN
	if ((void*)this < (void*)ExceptionEnv::stackTop && (void*)this > (void*)top) {	// this on stack
#else
	if ((void*)this > (void*)ExceptionEnv::stackTop && (void*)this < (void*)top) {	// this on stack
#endif
		next = stackTop->next;
		prev = stackTop;
		stackTop->next = this;
		next->prev = this;
	}
	else next = NULL;		// Catch object was allocated by new
}

Catch::~Catch()
{
	if (next != NULL) {
		next->prev = prev;
		prev->next = next;
	}
	obj->destroyer();
}

static ExceptionActionTbl mainExceptionActionTbl;
ExceptionActionTbl* ExceptionActionTbl::active = &mainExceptionActionTbl;

void NIHCL::setError(int err, int sev_, ...)
{
	ExceptionActionTbl::active->act((unsigned)err,sev_);
#ifdef TRACE
printf("seterror> Error No: %d  Severity: %d\n",err,sev_);
#endif
	errno = err;
        char buf[132],buf0[132];

	errfac_errorText(err,buf/*OUT*/);
     
	char* p = errfac_argumentCodes(err);
#ifdef TRACE
printf("seterror> argument codes %s\n",p);
#endif
	va_list ap;
	va_start(ap,sev_);
	while ( *p != '\0' ) { // set up next arg
	  int i;
	  char* s;
	  double d;
	  void* pt;
	  errfac_prepNextArg(buf/*IN*/,buf0/*OUT*/);
	  switch ( *(p++) ) {
	     case 'I': 
		i = va_arg(ap,int);
	     	sprintf(buf,buf0,i);
    	      	break;
	     case 'S':
		s = va_arg(ap,char*);
	     	sprintf(buf,buf0,s);
	        break;
		  case 'D':
	        d = va_arg(ap,double);
	     	sprintf(buf,buf0,d);
			  break;
		  case 'P':
		pt = va_arg(ap,void*);
			sprintf(buf,buf0,pt);
	        break;

	     default : // ignored
	        break;
	     }// end switch
          }// end while
	va_end(ap);

	int severity = (sev_ < 0)? sev_:(errfac_severity(err));
	errfac_errorMessage(severity,buf);
	if ( errfac_isExitSeverity(severity) ) {
	   cerr << "NIHCL: fatal: Tried to continue after error "
		<< err <<'\n';
	   abort();
	   }
}

ExceptionActionTbl::ExceptionActionTbl()
{
	client_exception_trap = NULL;
	for (register int i=NIHCL__LAST_ERROR-NIHCL__FIRSTERROR; i>=0; i--)
		action[i] = ExceptionAction::ABORT;
}

// error numbers depend on error facility setup 
#pragma warn -ccc               
#pragma warning (disable: 4727)
void ExceptionActionTbl::act(unsigned error, int sev)
{
	if (client_exception_trap != NULL) {
		(*client_exception_trap)(error,sev);
	}
	if (error >= NIHCL__FIRSTERROR &&
		 error <= NIHCL__LAST_ERROR) {
		switch (action[error-NIHCL__FIRSTERROR]) {
			case ExceptionAction::RAISE: RAISE(error);
			case ExceptionAction::ABORT: return;
		}
	}
}

ExceptionAction::ExceptionAction(unsigned error)
{
	if ( 	(error < NIHCL__FIRSTERROR)||
			(error > NIHCL__LAST_ERROR) ) {
		setError(NIHCL_BADERRNUM,DEFAULT,"ExceptionAction",error);
		return;
	}
	error_code = error;
	old_action = ExceptionActionTbl::active->action[error-NIHCL__FIRSTERROR];
}               
#pragma warning (default: 4727)
#pragma warn .ccc

ExceptionAction::~ExceptionAction()
{
	ExceptionActionTbl::active->action[error_code-NIHCL__FIRSTERROR] = old_action;
}                                           

AbortException::AbortException(unsigned error) : ExceptionAction(error)
{
	ExceptionActionTbl::active->action[error-NIHCL__FIRSTERROR] = ExceptionAction::ABORT;
}

RaiseException::RaiseException(unsigned error) : ExceptionAction(error)
{
	ExceptionActionTbl::active->action[error-NIHCL__FIRSTERROR] = ExceptionAction::RAISE;
}

ExceptionTrap::ExceptionTrap(exceptionTrapTy xtrap)
{
	old_trap = ExceptionActionTbl::active->client_exception_trap;
	ExceptionActionTbl::active->client_exception_trap = xtrap;
}

ExceptionTrap::~ExceptionTrap()
{
	ExceptionActionTbl::active->client_exception_trap = old_trap;
}
