/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Float.c,v 3.13 92/12/19 15:53:02 */
#include "nihclstd.h"
#pragma hdrstop

#include "NIHFloat.h"
#include "nihclIO.h"

#define	THIS	Float
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Float,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

Float::Float(istream& strm)	{ parseFloat(strm); }

#if defined(MIBADDEFAULTFCNS)
Float::Float(const Float& copyfrom): BASE(copyfrom),
	val(copyfrom.val)
{
}

Float& Float::operator=(const Float& rhs)
{
	if(this == &rhs)
		return *this;

	BASE::operator=(rhs);

	val = rhs.val;
	return *this;
}
#endif

int Float::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	double t = val-castdown(ob).val;
	if (t < 0) return -1;
	if (t > 0) return 1;
	return 0;
}

void Float::deepenShallowCopy()	{}

unsigned long Float::hash() const
{
	union {
		unsigned long asint[2];
		double asdouble;
	};
	asdouble = val;
	return asint[0] ^ asint[1];
}

bool Float::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && val==castdown(ob).val;
}

const Class* Float::species() const { return &classDesc; }

void Float::printOn(ostream& strm) const
{
	strm << val;
}

void Float::scanFrom(istream& strm)	{ parseFloat(strm); }

Float::Float(OIOin& strm)
	: BASE(strm)
{
	strm >> val;
}

void Float::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << val;
}

Float::Float(OIOifd& fd)
	: BASE(fd)
{
	fd >> val;
}

void Float::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << val;
}
