/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: KeySortCltn.c,v 3.13 92/12/19 */

#include "nihclstd.h"
#pragma hdrstop

#include "nihclIO.h"
#include "Assoc.h"
#include "KeySortC.h"

#define	THIS	KeySortCltn
#define	BASE	SortedCltn
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(KeySortCltn,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

KeySortCltn::KeySortCltn(int size) : BASE(size) {}

KeySortCltn::KeySortCltn(const KeySortCltn& c) : BASE(c) {}

LookupKey* KeySortCltn::assocAt(int i)
{
	return LookupKey::castdown(at(i));
}

Object* KeySortCltn::keyAt(int i)
{
	LookupKey& assoc = *assocAt(i);
	return assoc.key();
}

Object* KeySortCltn::valueAt(int i)
{
	LookupKey& assoc = *assocAt(i);
	return assoc.value();
}

Object* KeySortCltn::atKey(Object& key)
{
	// binary search for key
	int i = findIndexOf(key);

	if (i > -1 && key.compare(*keyAt(i)) == 0)
		return valueAt(i);
	else 
		return nil; // key not found
}

Assoc* KeySortCltn::addAssoc(Object& key, Object& val)
{
	Assoc* assoc = new Assoc(key,val);
	SortedCltn::add(*assoc);
	return assoc;
}

Collection& KeySortCltn::addValuesTo(Collection& c) const
{
	DO(*this,LookupKey,as) c.add(*(as->value())); OD
	return c;
}

Collection& KeySortCltn::addKeysTo(Collection& c) const
{
	DO(*this,LookupKey,as) c.add(*(as->key())); OD
	return c;
}

Collection& KeySortCltn::addContentsBeforeTo(Object& key,Collection& c)
{
	if (isEmpty()) return c;
	int k = findIndexOfLastKey(findIndexOf(key));
	if (k<0) return c;
	for (int i=0; i<=k; i++ )
		c.add(*at(i));
	return c;
}

KeySortCltn::KeySortCltn(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
}

KeySortCltn::KeySortCltn(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)

{
}
