/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: LinkOb.c,v 3.13 92/12/19 15:53:11 */

/*
Function:

Objects of class LinkOb are used to link Objects into a LinkedList.
*/                                                         

#include "nihclstd.h"
#pragma hdrstop

#include "LinkOb.h"
#include "nihclIO.h"

#define	THIS	LinkOb
#define	BASE	Link
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(LinkOb,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

LinkOb::LinkOb(Object& newval)
{
	val = &newval;
}

#ifdef BADDEFAULTFCNS 
LinkOb::LinkOb(const LinkOb& copyfrom)
{
	val = copyfrom.val;
}

LinkOb& LinkOb::operator=(const LinkOb& rhs)
{
	if(this == &rhs) return *this;
	BASE::operator=(rhs);
	val = rhs.val;
	return *this;
}
#endif

unsigned LinkOb::capacity() const		{ return val->capacity(); }

int LinkOb::compare(const Object& ob) const	{ return -ob.compare(*val); }

void LinkOb::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	val = val->deepCopy();
}

unsigned long LinkOb::hash() const			{ return val->hash(); }

bool LinkOb::isEqual(const Object& ob) const	{ return ob.isEqual(*val); }

void LinkOb::dumpOn(ostream& strm) const
{
	val->dumpOn(strm);
}

void LinkOb::printOn(ostream& strm) const
{
	val->printOn(strm);
}

unsigned LinkOb::size() const			{ return val->size(); }

Object* LinkOb::value() const	{ return val; }

Object* LinkOb::value(Object& newval)
{
	Object* temp = val;
	val = &newval;
	return temp;
}

LinkOb::LinkOb(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	val = Object::readFrom(strm);
}

void LinkOb::storer(OIOout& strm) const
{
	BASE::storer(strm);
	val->storeOn(strm);
}

LinkOb::LinkOb(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	val = Object::readFrom(fd);
}

void LinkOb::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	val->storeOn(fd);
}
