/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: LookupKey.c,v 3.13 92/12/19 15:53:14 */

/*
Function:
	
LookupKey is an abstract class for managing the key object of an Assoc.
It is used to implement class Dictionary.
*/

#include "nihclstd.h"
#pragma hdrstop

#include "LookupKe.h"
#include "nihclIO.h"

#define	THIS	LookupKey
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(LookupKey,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

#if defined(BADDEFAULTFCNS)
LookupKey::LookupKey(const LookupKey& copyfrom)
{
	akey = copyfrom.akey;
}

LookupKey& LookupKey::operator=(const LookupKey& rhs)
{
	if(this == &rhs)
		return *this;

	BASE::operator=(rhs);

	akey = rhs.akey;
	return *this;
}
#endif

LookupKey::LookupKey(Object& newKey)
{
	akey = &newKey;
}

Object* LookupKey::key() const { return akey; }

Object* LookupKey::key(Object& newkey)
{
	Object* temp = akey;
	akey = &newkey;
	return temp;
}

bool LookupKey::isEqual(const Object& ob) const { return ob.isEqual(*akey); }

unsigned long LookupKey::hash() const { return akey->hash(); }

int LookupKey::compare(const Object& ob) const { return -ob.compare(*akey); }

void LookupKey::deepenShallowCopy()
{
	akey = akey->deepCopy();
}

void LookupKey::dumpOn(ostream& strm) const
{
	strm << className() << '[';
	key()->dumpOn(strm);
	strm << "=>";
	value()->dumpOn(strm);
	strm << "]\n";
}

void LookupKey::printOn(ostream& strm) const
{
	key()->printOn(strm);
	strm << "=>";
	value()->printOn(strm);
}

const Object* LookupKey::value() const
{
	derivedClassResponsibility("value"); return NULL;
}

Object* LookupKey::value()
{
	derivedClassResponsibility("value"); return NULL;
}

Object* LookupKey::value(Object& /*newvalue*/)
{
	derivedClassResponsibility("value"); return NULL;
}

LookupKey::LookupKey(OIOin& strm)
	: BASE(strm)
{
	akey = Object::readFrom(strm);
}

void LookupKey::storer(OIOout& strm) const
{
	BASE::storer(strm);
	akey->storeOn(strm);
}

LookupKey::LookupKey(OIOifd& fd)
	: BASE(fd)
{
	akey = Object::readFrom(fd);
}

void LookupKey::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	akey->storeOn(fd);
}
