/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Nil.c,v 3.13 92/07/26 14:32:52  */

#include "nihclstd.h"
#pragma hdrstop

#include "nihclIO.h"

class Nil : public VIRTUAL Object {
	DECLARE_MEMBERS(Nil);
	Nil(const Nil&) {}
public:	
	Nil() {}
	virtual int compare(const Object&) const; // compare objects 
	virtual Object* copy() const;					// copy returns nil 
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned long hash() const;			// calculate object hash
	virtual bool isEqual(const Object&) const;// equality test 
	virtual void printOn(ostream& strm =cout) const;
private:				    	// shouldNotImplement 
	virtual void deepenShallowCopy();
	virtual void storer(OIOout&) const;
	virtual	void storer(OIOofd&) const;
};

extern const int NIHCL_RDUNKCLASS;

Object* const Object::nil = NULL;	    // initialized by NIHCLInitialize::NIHCLInitialize()

#define	THIS	Nil
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

Object* Nil::reader(OIOin&)		{ setError(NIHCL_RDUNKCLASS,DEFAULT,"Nil"); return nil; }
#ifndef NOOVERLOADONREF
Object* Nil::reader(OIOifd&)		{ setError(NIHCL_RDUNKCLASS,DEFAULT,"Nil"); return nil; }
#else 
Object* Nil::binreader(OIOifd&)	{ setError(NIHCL_RDUNKCLASS,DEFAULT,"Nil"); return nil; }
#endif

Object* Nil::shallowCopy() const	{ return nil; }

_DEFINE_CLASS_ALWAYS(Nil,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)
_DEFINE_CASTDOWN(Nil)

bool Nil::isEqual(const Object& ob) const { return (&ob==nil); }

unsigned long Nil::hash() const { return 0L; }

int Nil::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	return 0;
}

Object* Nil::copy() const { return nil; }

void Nil::dumpOn(ostream& strm) const { strm << "NIL"; }

void Nil::printOn(ostream& strm) const { strm << "NIL"; }

void Nil::deepenShallowCopy()	{ shouldNotImplement("deepenShallowCopy"); }

Nil::Nil(OIOin&) {}

Nil::Nil(OIOifd&) {}

void Nil::storer(OIOout&) const
/*
The Nil object is always implicitly stored as object number zero; all
references to nil are stored as @0.
*/
{
	shouldNotImplement("storer");
}

void Nil::storer(OIOofd&) const
{
	shouldNotImplement("storer");
}

//----------------------------------------------------------------------

// NIH Class Library Initialization

#include <errlib.h>

int NIHCLInitialize::initCount = 0;

unsigned char NIHCL::char_bit_mask[sizeof(char)*8];
unsigned short NIHCL::short_bit_mask[sizeof(short)*8];
unsigned int NIHCL::int_bit_mask[sizeof(int)*8];
unsigned char NIHCL::bit_count[256];
unsigned char NIHCL::bit_reverse[256];


void NIHCL::initTables()
{
	register unsigned i,j;
	
	for (i=0, j=1; i<sizeof(char)*8; i++, j <<= 1)  
		char_bit_mask[i] = (char)j; 	//(char) MFM
	for (i=0, j=1; i<sizeof(short)*8; i++, j <<= 1) 
		short_bit_mask[i] = (short)j; //(short) MFM
	for (i=0, j=1; i<sizeof(int)*8; i++, j <<= 1) 
		int_bit_mask[i] = j;

	for (i=0; i<256; i++) {
		bit_count[i] = 0;
		j = i;
		while (j != 0) {
			bit_count[i]++;
			j &= j-1;
		}
	}
	
	for (i=0; i<256; i++) {
		bit_reverse[i] = 0;
		j = i;
		register unsigned char m = 0x80;
		while (j != 0) {
			if ((j&1) != 0) bit_reverse[i] |= m;
			j >>= 1;
			m >>= 1;
		}
	}
}

extern void NIHCL__errinit();	// error facility initializer for NIHCL

NIHCLInitialize::NIHCLInitialize()
// Called once for every module that includes Object.h
{
	if (initCount++) return;
	NIHCL__errinit();			// initialize the NIHCL error handler 
	seterropt(ERROR,WARNING,NO,3,NULL);
	initTables();				// initialize NIHCL tables
	Object** nilp = (Object**)&Object::nil;	// create the nil object and
	*nilp = new Nil;			// initialize the pointer to it	
}
