/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Object.c,v 3.12 92/07/26 14:33:04  */

#include "nihclstd.h"
#pragma hdrstop

#include <ctype.h>          

#include "nihclIO.h"
#include "OIOTbl.h"
#include "Object.h"
#include "Dictiona.h"
#include "LookupKe.h"
#include "IdentDic.h"
#include "IdentSet.h"
#include "NIHStrin.h"
#include "Assoc.h"
#include "AssocInt.h"
#include "OrderedC.h"

extern const int NIHCL_AMBIGCASTDN,NIHCL_DRVDCLASSRSP,NIHCL_ILLEGALMFCN,NIHCL_BADARGCL,
	NIHCL_BADARGSP,NIHCL_BADARGCLM,NIHCL_BADARGSPM,NIHCL_BADCASTDN,NIHCL_BADCLASS,
	NIHCL_BADSTMBR,NIHCL_BADSPEC,NIHCL_RDABSTCLASS;

#define	THIS	Object
#define	BASE_CLASSES
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES      

// debugging option
#ifdef _DEBUG
Object::Object()
{
}
#endif

/* DEFINE_CLASS(); */

Object* Object::reader(OIOin&)
{
	setError(NIHCL_RDABSTCLASS,DEFAULT,"Object");
	return 0;
}
              
#ifndef NOOVERLOADONREF              
Object* Object::reader(OIOifd&)
{
	setError(NIHCL_RDABSTCLASS,DEFAULT,"Object");
	return 0;
}               
#else
Object* Object::binreader(OIOifd&)
{
	setError(NIHCL_RDABSTCLASS,DEFAULT,"Object");
	return 0;
}               
#endif

#if !(defined(NOOVERLOADONREF) || defined(BADVARARGSNULL))
static Class class_Object("Object",
	ClassList(NULL, NULL), ClassList(NULL, NULL), ClassList(NULL, NULL),
	1,	// version
	"$"__FILE__" "__DATE__" "__TIME__"$",
	sizeof(Object), Object::reader, Object::reader, NULL );
#else
static Class class_Object("Object",
	ClassList(0UL,0UL), ClassList(0UL,0UL), ClassList(0UL,0UL),
	1,	// version
	"$"__FILE__" "__DATE__" "__TIME__"$",
	sizeof(Object), Object::reader, Object::binreader, NULL );
#endif

const Class* Object::desc()	{ return &class_Object; }

void* Object::_castdown(const Class& target) const
{
	if (&target == &class_Object) return (void*)this;
	return NULL;
}

void* Object::_safe_castdown(const Class& target) const
{
	void* p = _castdown(target);
	if (p == NULL)
		setError(NIHCL_BADCASTDN,DEFAULT,this,className(),target.name());
	return p;
}

void Object::ambigCheck(void*& p, void*& q, const Class& target) const
{
	if (p == NULL || p == q) return;
	if (q == NULL) { q = p;  return; }
	setError(NIHCL_AMBIGCASTDN,DEFAULT,this,className(),target.name());
}

bool Object::isKindOf(const Class& clid) const
{
	return isA()->_isKindOf(clid);
}

unsigned Object::size() const { return 0; }

unsigned Object::capacity() const { return 0; }

const Class* Object::species() const	{ return isA(); }

Object* Object::copy() const { return shallowCopy(); }

static IdentDict* deepCopyDict =NULL;	// object ID -> object copy dictionary for deepCopy()
static IdentSet* deepCopyVBaseSet =NULL;	// deepened virtual base set for deepCopy()

Object* Object::deepCopy() const
{
	if (this == nil) return nil;
	bool firstObject = NO;
	if (deepCopyDict == NULL) {
		deepCopyDict = new IdentDict;
		firstObject = YES;
	}
	Assoc* asc = (Assoc*)deepCopyDict->assocAt(*this);
	if (asc == NULL) {				// object has not been copied
		Object* copy = shallowCopy();	// make a shallow copy 
		deepCopyDict->add(*new Assoc(*(Object*)this,*copy));	// add to dictionary 
		copy->deepenShallowCopy();	// convert shallow copy to deep copy 
		if (firstObject) {		// delete the deepCopy dictionary 
			DO(*deepCopyDict,Assoc,asc) delete asc; OD
			delete deepCopyDict;
			deepCopyDict = NULL;
			delete deepCopyVBaseSet;  // and the deepen VBase IdentSet
			deepCopyVBaseSet = NULL;
		}
		return copy;
	}
	else return asc->value();	// object already copied, just return object reference 
}

#ifdef MI

bool Class::_deepenVBase(const void* p)
{
	if (deepCopyVBaseSet == NULL) {
		deepCopyVBaseSet = new IdentSet(256);
		deepCopyVBaseSet->add(*(Object*)p);
		return YES;
	}
	if (deepCopyVBaseSet->includes(*(Object*)p)) return NO;
	deepCopyVBaseSet->add(*(Object*)p);
	return YES;
}

#endif

// error reporting 

void Object::derivedClassResponsibility(const char* fname) const
{
	setError(NIHCL_DRVDCLASSRSP,DEFAULT,this,className(),fname);
}

void Object::destroyer() {}

void Object::shouldNotImplement(const char* fname) const
{
	setError(NIHCL_ILLEGALMFCN,DEFAULT,this,className(),fname);
}

void Object::invalidArgClass(const Class& expect, const char* fname) const
{
	setError(NIHCL_BADARGCL,DEFAULT,fname,expect.name(),fname,className());
}

void Object::invalidArgClass(const Object& ob, const Class& expect, const char* fname) const
{
	setError(NIHCL_BADARGCLM,DEFAULT,className(),fname,expect.name(),className(),fname,ob.className());
}

void Object::invalidArgSpecies(const Class& expect, const char* fname) const
{
	setError(NIHCL_BADARGSP,DEFAULT,fname,expect.name(),fname,species()->className());
}

void Object::invalidArgSpecies(const Object& ob, const Class& expect, const char* fname) const
{
	setError(NIHCL_BADARGSPM,DEFAULT,className(),fname,expect.name(),className(),fname,ob.species()->name());
}

void Object::invalidClass(const Class& expect) const
{
	setError(NIHCL_BADCLASS,DEFAULT,expect.name(),className());
}

void Object::invalidSpecies(const Class& expect) const
{
	setError(NIHCL_BADSPEC,DEFAULT,expect.name(),species()->name());
}

void Object::dumpOn(ostream& strm) const
{
	strm << className() << '[';
	printOn(strm);
	strm << ']' << endl;
}

void Object::scanFrom(istream&) { derivedClassResponsibility("scanFrom"); }

// Object I/O

class StoreOnTblMgr {
	StoreOnTbl& tbl;
	friend void Object::storeOn(OIOout& strm) const;
	friend void Object::storeOn(OIOofd& fd) const;
	StoreOnTblMgr(StoreOnTbl& t) : tbl(t) {
		if (tbl.level++ == 0) tbl.reset();
	}
	~StoreOnTblMgr() { --tbl.level; } 
#ifdef _MSC_VER
	StoreOnTblMgr& operator=(const StoreOnTblMgr& unused); // quiet compiler
#endif		
};

void Object::storeOn(OIOout& strm) const
{
	StoreOnTblMgr mgr(strm);
	strm.storeObject(*this);
}

void Object::storeMemberOn(OIOout& strm) const
{
	if (strm.storeOnLevel() == 0) setError(NIHCL_BADSTMBR,DEFAULT,this,className());
	strm.addMember(*this);
	storer(strm);
}

void Object::storer(OIOout& /*strm*/) const	// store class Object 
{
}

Object::Object(OIOin& strm)
{
	strm.add(*this);	// add object to readFromTbl
}

// binary object I/O

void Object::storeOn(OIOofd& fd) const
{
	StoreOnTblMgr mgr(fd);
	fd.storeObject(*this);
}

void Object::storeMemberOn(OIOofd& fd) const
{
	if (fd.storeOnLevel() == 0) setError(NIHCL_BADSTMBR,DEFAULT,this,className());
	fd.addMember(*this);
	storer(fd);
}

void Object::storer(OIOofd& /*fd*/) const	// store Object on file descriptor
{
}

Object::Object(OIOifd& fd)
{
	fd.add(*this);
}

// Object Dependence Relationships 

static IdentDict* dependDict = NULL;	// object ID -> dependents list
	
Object* Object::addDependent(Object& ob)
{
	if (dependDict == NULL) dependDict = new IdentDict;
	if (!(dependDict->includesKey(*this)))
		dependDict->add(*new Assoc(*this,*new OrderedCltn));
	OrderedCltn::castdown(dependDict->atKey(*this))->add(ob);
	return &ob;
}

Object* Object::removeDependent(const Object& ob)
{
	if (dependDict == NULL) return nil;
	Object* val = dependDict->atKey(*this);
	if (val == nil) return nil;
	OrderedCltn* depList = OrderedCltn::castdown(val);
	Object* dependent = depList->removeId(ob);
	if (depList->size() == 0) release();
	return dependent;
}
	
OrderedCltn& Object::dependents() const
{
	if (dependDict == NULL) return *new OrderedCltn(1);
	Assoc* asc = (Assoc*)dependDict->assocAt(*this);
	if (asc == NULL) return *new OrderedCltn(1);
	return *new OrderedCltn(*OrderedCltn::castdown(asc->value()));
}
	
void Object::release()
{
	if (dependDict != NULL && dependDict->includesKey(*this)) {
		Assoc* asc = (Assoc*)dependDict->removeKey(*this);
		OrderedCltn* oc = OrderedCltn::castdown(asc->value());
		delete oc;
		delete asc;
		if (dependDict->size() == 0) {
			delete dependDict;
			dependDict = NULL;
		}
	}
}

void Object::changed(const Object& param)
{
	OrderedCltn* depList = &dependents();
	DO(*depList,Object,depob) depob->update(*this,param); OD
	delete depList;
}

void Object::changed()	{ changed(*nil); }

void Object::update(const Object& /*dependent*/, const Object& /*param*/)
{
	derivedClassResponsibility("update");
}
