/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: OIOnih.c,v 3.11 92/07/26 14:33:00 */

#include "nihclstd.h"
#pragma hdrstop

#include "OIOnih.h"
#include "OIOTbl.h"


extern const int NIHCL_DRVDCLASSRSP,NIHCL_ILLEGALMFCN,NIHCL_BADARGCL,
   NIHCL_BADARGSP,NIHCL_BADARGCLM,NIHCL_BADARGSPM,NIHCL_BADCLASS,NIHCL_BADSPEC,
   NIHCL_RDSYNERR,NIHCL_RDWRONGCLASS,
	NIHCL_RDUNKCLASS,NIHCL_RDVERSERR,NIHCL_RDABSTCLASS,NIHCL_RDBADSIG,
	NIHCL_RDBADTYP,NIHCL_READBINERR,NIHCL_STOREBINERR,
	NIHCL_READBINUNDFL;
	
Object* OIOnihin::readObject(const Class& expectedClass)
{
	char delim;									// delimiter character 
	const Class* readClass = NULL;		// class descriptor pointer
	int objectNum;								// object reference number 
	unsigned /*short*/ classNum;			// class reference number       /*short*/ MFM
	
// read first character of next object on input stream 
	*strm >> delim;
	checkRead();
	
// parse object reference, class reference, or class name & signature
	switch (delim) {
		case '@': {			// read object reference 
			*strm >> objectNum;
			checkRead();
#ifdef DEBUG_OBJIO
cerr << "readFrom: ref to object #" << objectNum
	<< ", class " << objectAt(objectNum)->className() << '\n';
#endif
			return objectAt(objectNum);
		}
		case '#': {			// read class reference
			*strm >> classNum >> delim;
			checkRead();
			if (delim != '{') syntaxErr("{",delim);
#ifdef DEBUG_OBJIO
cerr << "readFrom: ref to class #" << classNum << ", class ";
#endif
			readClass = classAt(classNum);
#ifdef DEBUG_OBJIO
cerr << *readClass << '\n';
#endif
			break;
		}
		case ':': {			// read class name and signature
			unsigned long signature;	// class signature 
			{
				char clsName[256];
				strm->get(clsName, sizeof clsName, '.');  *strm >> delim;
				checkRead();
				if (delim != '.') syntaxErr(".",delim);
				*strm >> signature >> delim;
				checkRead();
				if (delim != '{') syntaxErr("{",delim);
				if ((readClass = Class::lookup(clsName)) == NULL)
					setError(NIHCL_RDUNKCLASS, DEFAULT, clsName);
				if (!readClass->_isKindOf(expectedClass))
					setError(NIHCL_RDWRONGCLASS, DEFAULT, expectedClass.name(), clsName);
				if (readClass->signature() != signature)
				    setError(NIHCL_RDBADSIG, DEFAULT, clsName, readClass->signature(), signature);
			}
			classNum = add(readClass);
#ifdef DEBUG_OBJIO
cerr << "readFrom: class " << *readClass << '\n';
#endif
			break;
		}
		default: syntaxErr(":, # or @",delim);
	}
		
// call class object reader to read object
	Object* target = _readObject(*readClass);
	*strm >> delim;
	checkRead();
	if (delim != '}') syntaxErr("}",delim);
	return target;
}

void OIOnihout::storeObject(const Object& obj)
{
	int objectNum;
	if (add(obj,objectNum)) {	// object has not been stored 
		unsigned /*short*/ classNum;        // /*short*/
		if (addClass(obj.isA(),classNum))	// object of this class has not been previously stored 
			*strm << ':' << obj.className() << '.' << obj.isA()->signature();
		else *strm << '#' << classNum;		// object of this class already stored, just output class reference
		*strm << "{\n";
		_storer(obj);			// call storer for this object 
		*strm << "}\n";
	}
	else *strm << '@' << objectNum << '\n';	// object already stored, just output object reference 
}
