/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source:  */

/*	
A Point represents an x-y coordinate pair.  By convention, Point(0,0) is
the top left corner of the display, with x increasing to the right and y
increasing to the bottom.
*/
#include "nihclstd.h"
#pragma hdrstop

#include "Point.h"
#include "nihclIO.h"

#define	THIS	Point
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Point,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

#if defined(MIBADDEFAULTFCNS)
Point::Point(const Point& copyfrom)
	: BASE(copyfrom), xc(copyfrom.xc), yc(copyfrom.yc)
{
}

Point& Point::operator=(const Point& rhs)
{
	if(this == &rhs)
		return *this;

	BASE::operator=(rhs);

	xc = rhs.xc;
	yc = rhs.yc;
	return *this;
}
#endif

Point Point::max(const Point& p) const
{
	return Point(MAX(xc,p.xc),MAX(yc,p.yc));
}

Point Point::min(const Point& p) const
{
	return Point(MIN(xc,p.xc),MIN(yc,p.yc));
}

bool Point::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Point::species() const	{ return &classDesc; }

unsigned long Point::hash() const	{ return xc^yc; }

int Point::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	const Point& p = castdown(ob);
	int t = yc - p.yc;;
	if (t != 0) return t;
	else return xc - p.xc;
}

void Point::deepenShallowCopy()	{}

void Point::printOn(ostream& strm) const
{
	strm << '(' << xc << ',' << yc << ')';
}

Point::Point(OIOin& strm)
	: BASE(strm)
{
	strm >> xc >> yc;
}

void Point::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << xc << yc;
}

Point::Point(OIOifd& fd)
	: BASE(fd)
{
	fd >> xc >> yc;
}

void Point::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << xc << yc;
}
