/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Range.c,v 3.13 92/12/19 15:53:24  */

/*
Function:

Class Range implements an ordered pair of ints that can be used to indicate
a segment of some array (possibly a character string or vector).
*/
#include "nihclstd.h"
#pragma hdrstop

#include "Range.h"
#include "nihclIO.h"

#define	THIS	Range
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Range,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

#if defined(MIBADDEFAULTFCNS)
Range::Range(const Range& copyfrom): BASE(copyfrom),
	first(copyfrom.first),len(copyfrom.len)
{
}

Range& Range::operator=(const Range& rhs)
{
	if(this == &rhs)
		return *this;

	BASE::operator=(rhs);

	first = rhs.first;
	len = rhs.len;
	return *this;
}
#endif



//======= Protected member functions:

Range::Range(OIOin& strm)
	: BASE(strm)
{
	strm >> first >> len;
}

void Range::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << first << len;
}

Range::Range(OIOifd& fd)
	: BASE(fd)
{
	fd >> first >> len;
}

void Range::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << first << len;
}


//======= Public member functions:

void Range::deepenShallowCopy()  {}

unsigned long Range::hash() const
{
	return (first^len);
}

bool Range::isEqual(const Object& p) const
// Test two objects for equality
{
	return p.isSpecies(classDesc) && *this==castdown(p);
}

void Range::printOn(ostream& strm) const
{
	strm << first << ':' << len;
}

const Class* Range::species() const
// Return a pointer to the descriptor of the species of this class
{
	return Range::desc();
}

int Range::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
