/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Rectangle.c,v 3.13 92/12/19 15:53:25 */

#include "nihclstd.h"
#pragma hdrstop

#include "Rectangl.h"
#include "nihclIO.h"

#define	THIS	Rectangle
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES Point::desc(),Point::desc()
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Rectangle,2,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

Rectangle::Rectangle(int left, int top, int height, int width)
{   
	tl = Point(left,top);
	br = Point(left+width,top+height);
}

Rectangle::Rectangle(const Point& o, const Point& c)
{
	tl = o;
	br = c;
}

Rectangle::Rectangle(const Rectangle& r) : tl(r.tl), br(r.br) {}

bool Rectangle::operator==(const Rectangle& r) const
{
	return (tl==r.tl && br==r.br);
}

Rectangle Rectangle::operator&&(const Rectangle& r) const
{
	return Rectangle(tl.max(r.tl), br.min(r.br));
}

Rectangle Rectangle::operator||(const Rectangle& r) const
{
	return Rectangle(tl.min(r.tl),
		br.max(r.br));
}

void Rectangle::operator+=(const Point& p)
{
	tl += p;
	br += p;
}

void Rectangle::operator-=(const Point& p)
{
	tl -= p;
	br -= p;
}

bool Rectangle::contains(const Point& p) const
{
	return (tl <= p) && (p <= br);
}

bool Rectangle::contains(const Rectangle& r) const
{
	return (contains(r.tl) && contains(r.br));
}

bool Rectangle::intersects(const Rectangle& r) const
{
	if (tl.max(r.tl) < br.min(r.br)) return YES;
	return NO;
}

void Rectangle::moveTo(const Point& p)
/*
	Move this Rectangle so its origin is at p.
*/
{
	br += p-tl;
	tl = p;
}

void Rectangle::deepenShallowCopy()	{}

unsigned long Rectangle::hash() const	{ return tl.hash()^br.hash(); }

bool Rectangle::isEqual(const Object& r) const
{
	return r.isSpecies(classDesc) && *this==castdown(r);
}

const Class* Rectangle::species() const { return &classDesc; }

void Rectangle::printOn(ostream& strm) const
{
	strm << tl << " corner: " << br;
}

Rectangle::Rectangle(OIOin& strm)
	: BASE(strm),
	tl(strm), br(strm)
{
}

void Rectangle::storer(OIOout& strm) const
{
	BASE::storer(strm);
	tl.storeMemberOn(strm);
	br.storeMemberOn(strm);
}

Rectangle::Rectangle(OIOifd& fd)
	: BASE(fd),
	tl(fd), br(fd)
{
}

void Rectangle::storer(OIOofd& fd) const 
{
	BASE::storer(fd);
        tl.storeMemberOn(fd);
	br.storeMemberOn(fd);
}

int Rectangle::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
