/* MS-DOS version of NIH class library - Michael F. Murphy 4/93 */
/* Unix source: Stack.c,v 3.13 92/07/26 14:33:47  */

#include "nihclstd.h"
#pragma hdrstop

#include "Stack.h"
#include "nihclIO.h"

#define	THIS	Stack
#define	BASE	SeqCltn
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES OrderedCltn::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Stack,2,"$"__FILE__" "__DATE__" "__TIME__"$",NULL)

Stack::Stack(unsigned size) : contents(size) {}

Stack::Stack(const Stack& s) : contents(s.contents) {}

Object* Stack::add(Object& ob)	{ return contents.add(ob); }

Object*& Stack::at(int i)			{ return contents.at(size()-i-1); }

const Object *const& Stack::at(int i) const	{ return contents.at(size()-i-1); }

unsigned Stack::capacity() const	{ return contents.capacity(); }

void Stack::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	contents.deepenShallowCopy();
}

unsigned long Stack::hash() const		{ return contents.hash(); }

bool Stack::isEmpty() const		{ return contents.size()==0; }

Object* Stack::last() const		{ return contents.last(); }

void Stack::reSize(unsigned newSize) { contents.reSize(newSize); }

void Stack::removeAll()
{
	contents.removeAll();
}

Object* Stack::removeLast()	{ return contents.removeLast(); }

unsigned Stack::size() const		{ return contents.size(); }

Stack::Stack(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	contents(strm)
{
}

void Stack::storer(OIOout& strm) const
{
	BASE::storer(strm);
	contents.storeMemberOn(strm);
}

Stack::Stack(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	contents(fd)
{
}

void Stack::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	contents.storeMemberOn(fd);
}

void Stack::atAllPut(Object&)	{ shouldNotImplement("atAllPut"); }

int Stack::indexOfSubCollection(const SeqCltn& /* cltn */, int /* start */) const
{
	shouldNotImplement("indexOfSubCollection");
	return 0;
}

Object* Stack::remove(const Object&)
{
	shouldNotImplement("remove");
	return 0;
}

void Stack::replaceFrom(int /* start */, int /* stop */, const SeqCltn&  /* replacement */, int /* startAt */)
{
	shouldNotImplement("replaceFrom");
}
