REM checknih.bat verification of MS-DOS NIH class operations
@echo off
echo array 
.\array | diff -s -c - array.v
echo bag
echo "*** Expect differences in ordering. MFM ***"
pause
.\bag | diff -s -c - bag.v | more
echo bitset
.\bitset | diff -s -c - bitset.v
echo bitboard
.\bitboard | diff -s -c - bitboard.v
echo class
echo "Expect at least as many classes as in the .v file - MFM"
pause
.\class | diff -s -c - class.v | more
echo "Classes shown depend on how many are linked in."
echo "*** Class IdentSet may be absent if not compiled with -DMI. ***"
pause
echo date
echo Expect differences. Check that compare values have same sign -1, 0, +1 
Pause
.\nihdate <date.in | diff -s -c - date.v | more
pause
echo dep
.\dep | diff -s -c - dep.v
echo dict
echo Expect ordering differences with asSet() - MFM
pause
.\dict | diff -s -c - dict.v
pause
echo error
.\error | diff -s -c - error.v
echo "MS-DOS can not redirect stderr" 
echo "*** [CLTNEMPTY] error message to stderr not stdout OK. - MFM ***"     
echo "*** Different # in param 1 of trap OK - MFM. ***"   
echo "*** Different address in [CLTNEMPTY] error message OK. ***"
pause
echo except
.\except  | diff -s -c - except.v
echo "MS-DOS can not redirect stderr"
echo "*** Output of NIHCL:fatal to stderr instead of file OK. ***" 
pause
echo fraction
echo Expect differences (E4 and E-3 not E+-6) MS-DOS implementation - MFM
pause
.\fraction | diff -s -c - fraction.v
echo "*** Implementations may differ in placing '0' before decimal point. ***"
pause
echo heap
echo Expect order differences in asSet() - MFM
pause
.\heap | diff -s -c - heap.v
pause
echo identdic
.\identdic | diff -s -c - identdic.v
REM optional - compare objects directly
REM diff -s -c identdic.io identdic.ob
echo identset
.\identset | diff -s -c - identset.v
REM optional - compare objects directly
REM diff -s -c identset.io identset.ob
echo iterator
.\iterator | diff -s -c - iterator.v
echo linkedlist
echo Expect order differences in asSet() - MFM
pause
.\linkedli | diff -s -c - linkedli.v
pause
echo keysortcltn
.\keysortc | diff -s -c - keysortc.v
echo object
.\object | diff -s -c - object.v
echo oio
echo Expect 2 fewer classes (no fdset or arraychar) and 4 less objects - MFM
pause
.\oio oioa.obx oiob.obx | diff -s -c - oio.v
pause
REM optional - compare objects directly
REM diff -s -c oioa.obx oioa.ob
REM diff -s -c oiob.obx oiob.ob
echo oio -b
echo Same as above
pause
.\oio -b oioba.obx oiobb.obx | diff -s -c - oiob.v
REM optional - compare objects directly
REM diff -s -c oioba.obx oioba.ob
REM diff -s -c oiobb.obx oiobb.ob
pause
echo TO DO test the .io and .obx files
pause
echo orderedcltn
echo Expect order differences in asSet()
pause
.\orderedc | diff -s -c - orderedc.v
pause
echo point
.\point | diff -s -c - point.v
echo random
echo Implementation difference - rounding - MFM
pause
.\random | diff -s -c - random.v
echo "*** Implementations may differ in placing '0' before decimal point. ***"
pause
echo range
.\range | diff -s -c - range.v
echo rectangle;
.\rectangl | diff -s -c - rectangl.v
echo regex
.\regex <regex.in | diff -s -c - regex.v
REM no test to compare objects directly
pause
echo seqcltn
.\seqcltn | diff -s -c - seqcltn.v
echo sets
echo Expect order differences - MFM
.\sets | diff -s -c - sets.v | more
pause
echo signature
echo Expect differences based on number of classes
echo Could have 20+ here, depending - MFM
pause
.\signatur | ..\gnu\sed -e "s/\$.*\$/$$/" | diff -s -c -  signatur.v | more
pause
echo sortedcltn
echo Expect order differences with asSet()
pause
.\sortedcl | diff -s -c - sortedcl.v
pause
echo stack
.\stack | diff -s -c - stack.v
echo "*** Expect [CLTNEMPTY] error message ***"
pause
echo string
.\string | diff -s -c - string.v
echo substring
.\substrin | diff -s -c - substrin.v
echo tim
.\tim <tim.in | diff -s -c - tim.v


