/* Test Object dependencies


*/

/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * main() return value
 * ulong hash()
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Point.h>
#include <OrderedC.h>
#include <nihclIO.h>

class MyPoint: public Point {
	DECLARE_MEMBERS(MyPoint);
public:
	MyPoint(int newx, int newy) : Point(newx,newy) {}
	~MyPoint()	{ release(); }
	int x() const	{ return Point::xc; }
	int y() const	{ return Point::yc; }
	int x(int newx)	{ Point::xc = newx; changed(); return Point::xc; }
	int y(int newy)	{ Point::yc = newy; changed(); return Point::yc; }
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Point::storer(fd); }
	virtual	void storer(OIOout& strm) const	{ Point::storer(strm); }
};

MyPoint::MyPoint(OIOin&) {}

MyPoint::MyPoint(OIOifd&) {}

#define BASE Point
#define BASE_CLASSES Point::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(MyPoint,1,"",NULL)

class PointView: public VIRTUAL Object {
	DECLARE_MEMBERS(PointView);
	Point* p;
public:
	PointView(Point& newp)	{ p = &newp; p->addDependent(*this); update(*p,*nil); }
	~PointView()		{ p->removeDependent(*this); }
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual unsigned long hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void update(const Object&, const Object&);
	virtual void printOn(ostream& strm =cout) const;
};

#undef BASE
#define BASE Object
#undef BASE_CLASSES
#define BASE_CLASSES Object::desc()

DEFINE_CLASS(PointView,1,"",NULL)

int PointView::compare(const Object& a) const { return p->compare(a); }

void PointView::deepenShallowCopy()
{
	p = Point::castdown(p->deepCopy());
}

unsigned long PointView::hash() const    { return p->hash(); }

bool PointView::isEqual(const Object& a) const	{ return p->isEqual(a); }

void PointView::update(const Object& p, const Object& /*unused*/)
{
	cout << p.className() << " changed: " << p << endl;
	cout.flush();
}

void PointView::printOn(ostream& strm) const
{
	strm << *p << endl;
}

PointView::PointView(OIOin&) {}

PointView::PointView(OIOifd&) {}

main()
{
	cout << "Test Object Dependencies" << endl;
	MyPoint p(0,0);
	PointView* v = new PointView(p);
	p.dependents().dumpOn(cout);
	p.x(1); p.y(2);		/* should print changes */
	delete v;
	p.dependents().dumpOn(cout);
	p.x(3); p.y(4);		/* should not print changes */
	v = new PointView(p);
	p.x(5); p.y(6);		/* should print changes */
	p.release();
	p.dependents().dumpOn(cout);
	p.x(7); p.y(8);		/* should not print changes */
	return 0;
}
