/* Test exception handling

*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * stream.h ->iostream.h
 * return value for main
 * output to cout instead of cerr
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Exceptio.h>
#include <iostream.h>

enum exceptionCode { EXCEPTION1=1, EXCEPTION2, EXCEPTION3, EXCEPTION4 };

void x(exceptionCode n)
{
	BEGINX
		if (n>EXCEPTION2) {
			cout << "Raising EXCEPTION" << (int) n << "...";
			RAISE(n);
		}
		cout << "Trying normal return from function\n";
		return;
	EXCEPTION
		case EXCEPTION3: cout << "EXCEPTION3 handled\n"; return;
		default: cout << "trying RAISE(EXCEPTION_CODE)...";
			RAISE(EXCEPTION_CODE);
	ENDX
}

main()
{
	cout << "Begin exception handler test\n";

	BEGINX
		cout << "Testing normal execution\n";
	EXCEPTION
		default: cout << "This should not happen!\n";
	ENDX

	BEGINX
		cout << "Raising EXCEPTION1...";
		RAISE(EXCEPTION1);
		cout << "EXCEPTION1 not handled!\n";
	EXCEPTION
		case EXCEPTION1: cout << "EXCEPTION1 handled\n";
	ENDX
	
	BEGINX
		cout << "Testing nested exception block\n";
		x(EXCEPTION2);
		BEGINX
			cout << "Raising EXCEPTION2...";
			RAISE(EXCEPTION2);
			cout << "EXCEPTION2 not handled!\n";
		EXCEPTION
			case EXCEPTION2: cout << "EXCEPTION2 handled\n";
				cout << "Raising EXCEPTION3...";
				x(EXCEPTION3);
		ENDX
		
		cout << "Raising EXCEPTION4...";
		x(EXCEPTION4);
		cout << "EXCEPTION4 not handled!\n";

	EXCEPTION
		default: cout << "Test unhandled exception handler\n";
			RAISE(EXCEPTION_CODE);
	ENDX
	return 0;
}
