/* Test class IdentDict


*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * include for __MSDOS__
 * return value for main()
 * .io extension rather than .obj
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Point.h>
#include <IdentDic.h>
#include <Assoc.h>
#include <AssocInt.h>
#include <SortedCl.h>
#include <OIOnih.h>
#include <fstream.h>
#include <fcntl.h>
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif

const char* fileName = "identdic.io";

Point pkey;
#define POINT(X,Y)  *(pkey.x(X),pkey.y(Y),&pkey)

Integer ikey;
#define INTEGER(X)  *(ikey.value(X), &ikey)

main()
{
	cout << "\nTest class IdentDict" << endl;
	IdentDict d(16);
	Point a(1,1), b(1,2), c(1,3);
	AssocInt asc(c,3);
	d.add(*new AssocInt(a,1));
	d.add(*new AssocInt(b,2));
	d.add(asc);
	cout << "d = ";  d.asSortedCltn().dumpOn(cout);
	cout << "d.atKey(a): " << *(d.atKey(a)) << endl;
	cout << "d.includesKey(Point(1,1)): " << d.includesKey(POINT(1,1)) << endl;
	d.atKey(a,*new Integer(0));
	cout << "d.atKey(a): " << *(d.atKey(a)) << endl;
	cout << "d.includesAssoc(asc): " << d.includesAssoc(asc) << endl;
	cout << "d.includesKey(" << (*asc.key()) << "): " << d.includesKey(*asc.key()) << endl;
	cout << "d.keyAtValue(Integer(0)) = " << *d.keyAtValue(INTEGER(0)) << endl;
	d.removeKey(c);
	cout << "d.includesAssoc(asc): " << d.includesAssoc(asc) << endl;
	cout << "d.includesKey(" << (*asc.key()) << "): " << d.includesKey(*asc.key()) << endl;
	Point p = c;
	d.add(asc);
	d.add(*new AssocInt(p,4));
	cout << "d = ";  d.asSortedCltn().dumpOn(cout);
	{
		 ofstream out(fileName);
		 OIOnihout oout(out);
		 d.storeOn(oout);
		 out.close(); // MFM
	}
	IdentDict* dp =NULL;
	{
		 ifstream in(fileName);
		 OIOnihin oin(in);
		 dp = IdentDict::readFrom(oin);
		 in.close(); // MFM
	}
	dp->asSortedCltn().dumpOn(cout);
	SortedCltn keys,vals;
	cout << "d.addKeysTo(keys): " << dp->addKeysTo(keys) << endl;
	cout << "d.addValuesTo(vals): " << dp->addValuesTo(vals) << endl;
	return 0;
}
