/* Test class KeySortCltn


*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * main() return value
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <KeySortC.h>
#include <NIHStrin.h>
#include <Date.h>
#include <NIHFloat.h>
#include <NIHTime.h>
#include <Integer.h>

KeySortCltn c;

String skey(1);
#define STRING(X) *(skey=X,&skey)

static void part1()
{
	c.addAssoc(*new String("A"),*new String("Ant"));
	c.addAssoc(*new String("M"),*new String("Man"));
	c.addAssoc(*new String("C"),*new String("Cat"));
	c.addAssoc(*new String("E"),*new String("Emu"));
	c.addAssoc(*new String("H"),*new Date(25,"Dec",85));
	c.addAssoc(*new String("J"),*new Float(98.6));
	c.addAssoc(*new String("E"),*new String("Eeyore"));
	c.addAssoc(*new String("Z"),*new Time(Date(29,"Jan",63),21,30));

	c.printOn(cout); cout << endl;

	int k;
	k = c.findIndexOf(STRING("A"));
	cout << "index " << k << " before key A" << endl;
	k = c.findIndexOf(STRING("M"));
	cout << "index " << k << " before key M" << endl;
	k = c.findIndexOf(STRING("C"));
	cout << "index " << k << " before key C" << endl;
	k = c.findIndexOf(STRING("E"));
	cout << "index " << k << " before key E" << endl;
	k = c.findIndexOf(STRING("Z"));
	cout << "index " << k << " before key Z" << endl;
	k = c.findIndexOf(STRING("F"));
	cout << "index " << k << " before key F" << endl;
	k = c.findIndexOf(STRING("@"));
	cout << "index " << k << " before key @" << endl;
	k = c.findIndexOf(STRING("["));
	cout << "index " << k << " before key [" << endl;
}

static void part2()
{
	KeySortCltn clone = *KeySortCltn::castdown(c.copy());
	cout << "clone isEqual c: " << c.isEqual(clone) << endl;
	cout << "clone == c: " << (c == (clone)) << endl;
	cout << "clone != c: " << (c != (clone)) << endl;
	cout << "c.compare(clone) = " << c.compare(clone) << endl;
	cout << "c.includes(String(\"J\")) = " 
				 << c.includes(STRING("J")) << endl;
	cout << "c.includes(String(\"K\")) = " 
				 << c.includes(STRING("K")) << endl;
	cout << "c.occurrencesOf(String(\"Q\")) = " 
				 << c.occurrencesOf(STRING("Q")) << endl;
	cout << "c.occurrencesOf(String(\"M\")) = " 
				 << c.occurrencesOf(STRING("M")) << endl;
	cout << "c.occurrencesOf(String(\"E\")) = " 
				 << c.occurrencesOf(STRING("E")) << endl;

	cout << "atKey(String(\"J\")) = " << *c.atKey(STRING("J"))
		  << endl;
	cout << "atKey(String(\"N\")) = " << *c.atKey(STRING("N"))
		  << endl;
}

static void part3()
{
	OrderedCltn o;
	c.addValuesTo(o);
	c.addKeysTo(o);
	cout << "\nOrderedCltn o =" << endl;
	cout << o << endl;

	SortedCltn b;
	c.addContentsBeforeTo(STRING("E"), b);
	cout << "\nSortedCltn b =" << endl;
	cout << b << endl;

	cout << "*c.remove(String(\"Z\")) = " << *c.remove(STRING("Z")) << endl;
	cout << "*c.remove(String(\"Q\")) = " << *c.remove(STRING("Q")) << endl;
	cout << "*c.remove(String(\"E\")) = " << *c.remove(STRING("E")) << endl;
	c.printOn(cout); cout << endl;

	const int ARRAY_SIZE = 4;
	ArrayOb x(ARRAY_SIZE), y(ARRAY_SIZE), z(ARRAY_SIZE);
	String s0("apple"), s1("bat"), s2("cat");
	String s3("gopher"), s4("dog"), s5("eagle");

	int i;
	for (i = 0; i < ARRAY_SIZE - 1; i++)
		switch (i) {
			case (0):
				x[i] = y[i] = z[i] = &s0;
				break;
			case (1):
				x[i] = y[i] = z[i] = &s1;
				break;
			case (2):
				x[i] = y[i] = z[i] = &s2;
				break;
		} /* switch */

	x[ARRAY_SIZE - 1] = &s3;
	y[ARRAY_SIZE - 1] = &s4;
	z[ARRAY_SIZE - 1] = &s5;

	KeySortCltn d;

	d.addAssoc(x, *new Integer(0));
	d.addAssoc(y, *new Integer(1));
	d.addAssoc(z, *new Integer(2));
	cout << endl; d.printOn(cout); cout << endl;
	int k;
	k = d.findIndexOf(y);
	cout << "index "; y.printOn(cout); cout << "\nbefore key " << k << endl;
}

main()
{
	cout << "\nTest class KeySortCltn" << endl;
	part1();
	part2();
	part3();
	return 0;
}
