/* Test class LinkedList

*/
/* MSDOS revisions - Michael Murphy 1993
 * 8.3 filenames
 * main() return value
 */

#include "nihclstd.h"
#pragma hdrstop 
 
#include <Point.h>
#include <LinkedLi.h>
#include <LinkOb.h>
#include <Set.h>

main()
{
	cout << "\nTest class LinkedList" << endl;
	Point A(1,1);
	Point B(1,2);
	Point C(1,3);
	Point D(1,3);
	LinkOb bA(A);
	LinkOb bB(B);
	LinkOb bC(C);
	LinkOb bD(D);
	LinkedList b;
	b.add(bA);
	b.add(bB);
	b.add(bC);
	b.add(bD);
	LinkedList& c = *LinkedList::castdown(b.deepCopy());
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	cout << "b[3]: " << *b[3] << endl;
	b.reSize(30);
	cout << "b.includes(C): " << b.includes(C) << endl;
	cout << "c == b: " << (c==b) << endl;
	b.addFirst(*new LinkOb(*new Point(1,0)));
	b.addLast(*new LinkOb(*new Point(1,19)));
	cout << "b = " << b << endl;
	b.addAll(c);
	cout << "b = " << b << endl;
	b.remove(*b[1]);
	cout << "b.includes(A): " << b.includes(A) << endl;
	cout << "b = " << b << endl;
	cout << "c == b: " << (c==b) << endl;
	cout << "b.indexOf(D): " << b.indexOf(D) << endl;
	cout << "c = " << c << endl;
	DO(c,Object,ob) cout << *ob; OD
	cout << endl;
	cout << "c.size() = " << c.size() << endl;
	LinkOb::castdown(c[1])->value(A);
	cout << "c = " << c << endl;
	while (c.size() != 0) {
		c.remove(*c.first());
		cout << "c = " << c << endl;
	}
	cout << "b.asSet(): " << (b.asSet()) << endl;
	b.removeAll();
	b.add(bA);
	b.add(bC);
	b.addAfter(bA,bB);
	b.addAfter(bC,bD);
	D = Point(1,4);
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	cout << "b.size(): " << b.size() << endl;
	b.removeAll();
	return 0;
}
