/* Test class Regex

*/

#include "nihclstd.h"
#pragma hdrstop 
 
#include <NIHRegex.h>
#include <OIOnih.h>
#include <fstream.h>
#ifdef __MS_DOS__
#include <stdlib.h>
#elif defined(__DECCXX)
#include <stdlib.h>
#else
#include <osfcn.h>
#endif

void printGroups(const Regex& r, const String& s, ostream& strm =cout)
{
	for (int i=0; i<r.groups(); i++) {   
#ifdef _MSC_VER               
		strm << '\\' << i << ":	" << ((String&)s)(r[(unsigned)i])
					<< "	[" << s << '(' << r[(unsigned)i] << ")]" << endl;
#else 
		strm << '\\' << i << ":	" << ((String&)s)(r[i]) 
					<< "	[" << s << '(' << r[i] << ")]" << endl;
#endif      

	}
}

void testPattern(Regex& r, const String& s, ostream& strm =cout)
{
	strm << r << " match(" << s << ")? "
		<< (r.match(s) ? "YES" : "NO") << endl;
	printGroups(r,s);
	strm << r << " search(" << s << ")? "
		<< (r.search(s) != -1 ? "YES" : "NO") << endl;
	printGroups(r,s);
	strm << r << " search(" << s << ',' << s.length()-1 << ',' << -(int)s.length()+1 << ")? "
		<< (r.search(s,s.length()-1,-(int)s.length()+1) != -1 ? "YES" : "NO") << endl;
	printGroups(r,s);
	cout << "---" << endl;
}

const char* fileName = "regex.io";
extern unsigned _stklen = 24000;
void main()
{
	cout << "\nTest Class Regex" << endl;
	Regex r = "\\([^a-zA-Z]*\\)\\([a-zA-Z]+\\)\\([^a-zA-Z]*\\)";
	testPattern(r,"123First123456789");
	Regex r2 = r;
	testPattern(r2,"123First123456789");
	Regex r3;
	r3 = r;

	testPattern(r3,"123First123456789");
	{ // storeOn r3 to stream attached to fileName
		 ofstream out(fileName);
		 OIOnihout nihout(out);
		 r3.storeOn(nihout);
		 // MFM
		 out.close();
	}

	Regex* rp;
	{ // readFrom rp from stream attached to fileName
		 ifstream in(fileName);
		 OIOnihin nihin(in);
		 rp = Regex::readFrom(nihin);
		 // MFM
		 in.close();
	}
	testPattern(*rp,"123First123456789");


	String s;
	while (YES) {
		cout << "Enter PATTERN: "; cin >> r;
		if (cin.eof()) {
			cout << endl;
			exit(0);
		}
		while (YES) {
			cout << "Enter STRING: "; cin >> s;
			if (cin.eof()) {
				cout << endl;
				exit(0);
			}
			if (s.length()==0) break;
			testPattern(r,s);
		}
	}
}
