
// WCONNECT.CPP

#include <windows.h>
#include <string.h>    // for strstr()
#include <stdio.h>
#include "owlcomm.h"

static HWND HWindow;

BOOL Connect(HWND HWindow)
   {
   BOOL bResult;


   if (!nActiveComPort)
       {
       nActiveComPort = InitComPort(HWindow,COMPORT);
       if (nActiveComPort < 0)
           {
           MessageBeep(MB_ICONEXCLAMATION);
	   MessageBox(HWindow,"Could not activate COM port.","Example Windows Terminal",MB_ICONSTOP);
	   PostMessage(HWindow,WM_CLOSE,0,0L);
           return FALSE;
           }
       }

   if (!bConnected)
       {
       bResult = InitModem(HWindow,nActiveComPort);
       if (!bResult)
           {
           MessageBeep(MB_ICONEXCLAMATION);
	   MessageBox(HWindow,"Could not initialize modem.","Example Windows Terminal",MB_ICONSTOP);
	   PostMessage(HWindow,WM_CLOSE,0,0L);
           return FALSE;
           }

	   if (!EnableCommNotification(nActiveComPort,HWindow,32,32))
               {
               MessageBeep(MB_ICONEXCLAMATION);
	       MessageBox(HWindow,"Unable to initialize Comm messages.",
                               "Example Windows Terminal",MB_ICONSTOP);
	       PostMessage(HWindow,WM_CLOSE,0,0L);
               }
	   //bEcho = FALSE;
           } 


   return TRUE;
   }



BOOL Dial(char *DailInput)
   {
   int nResult;
   BOOL bReturnValue;
   HANDLE hBufferMem;
   LPSTR szModemResponse;
   char c[45];
   sprintf(c,"ATDT%s%s",DailInput,"\r");
   nResult = WriteComPort(nActiveComPort,c,lstrlen(c));
   CheckComPort(nActiveComPort,NULL);
   if (nResult < 0)
       return FALSE;
   }




void Disconnect(void)
   {
   bConnected = HangUpModem(nActiveComPort);
   nActiveComPort = CloseComPort(nActiveComPort);
   }
